/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.resolver;

import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.mention.Parse;
import chalk.tools.coref.resolver.NonReferentialResolver;
import chalk.tools.coref.resolver.ResolverMode;
import chalk.tools.coref.resolver.ResolverUtils;
import chalk.tools.util.CollectionEventStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nak.io.BinaryGISModelReader;
import nak.io.SuffixSensitiveGISModelReader;
import nak.io.SuffixSensitiveGISModelWriter;
import nak.maxent.GIS;
import nak.model.AbstractModel;
import nak.model.Event;
import nak.model.EventStream;
import nak.model.MaxentModel;

public class DefaultNonReferentialResolver
implements NonReferentialResolver {
    private MaxentModel model;
    private List<Event> events;
    private boolean loadAsResource;
    private boolean debugOn = false;
    private ResolverMode mode;
    private String modelName;
    private String modelExtension = ".bin.gz";
    private int nonRefIndex;

    public DefaultNonReferentialResolver(String string, String string2, ResolverMode resolverMode) throws IOException {
        this.mode = resolverMode;
        this.modelName = string + "/" + string2 + ".nr";
        if (resolverMode == ResolverMode.TRAIN) {
            this.events = new ArrayList<Event>();
        } else if (resolverMode == ResolverMode.TEST) {
            this.model = this.loadAsResource ? new BinaryGISModelReader(new DataInputStream(this.getClass().getResourceAsStream(this.modelName))).getModel() : new SuffixSensitiveGISModelReader(new File(this.modelName + this.modelExtension)).getModel();
            this.nonRefIndex = this.model.getIndex("same");
        } else {
            throw new RuntimeException("unexpected mode " + (Object)((Object)resolverMode));
        }
    }

    @Override
    public double getNonReferentialProbability(MentionContext mentionContext) {
        List<String> list = this.getFeatures(mentionContext);
        double d = this.model.eval(list.toArray(new String[list.size()]))[this.nonRefIndex];
        if (this.debugOn) {
            System.err.println(this + " " + mentionContext.toText() + " ->  null " + d + " " + list);
        }
        return d;
    }

    @Override
    public void addEvent(MentionContext mentionContext) {
        List<String> list = this.getFeatures(mentionContext);
        if (-1 == mentionContext.getId()) {
            this.events.add(new Event("same", list.toArray(new String[list.size()])));
        } else {
            this.events.add(new Event("diff", list.toArray(new String[list.size()])));
        }
    }

    protected List<String> getFeatures(MentionContext mentionContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("default");
        arrayList.addAll(this.getNonReferentialFeatures(mentionContext));
        return arrayList;
    }

    protected List<String> getNonReferentialFeatures(MentionContext mentionContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Parse[] parseArray = mentionContext.getTokenParses();
        for (int i = 0; i <= mentionContext.getHeadTokenIndex(); ++i) {
            Parse parse = parseArray[i];
            List<String> list = ResolverUtils.getWordFeatures(parse);
            for (int j = 0; j < list.size(); ++j) {
                arrayList.add("nr" + list.get(j));
            }
        }
        arrayList.addAll(ResolverUtils.getContextFeatures(mentionContext));
        return arrayList;
    }

    @Override
    public void train() throws IOException {
        if (ResolverMode.TRAIN == this.mode) {
            System.err.println(this + " referential");
            if (this.debugOn) {
                FileWriter fileWriter = new FileWriter(this.modelName + ".events");
                for (Event event : this.events) {
                    fileWriter.write(event.toString() + "\n");
                }
                fileWriter.close();
            }
            new SuffixSensitiveGISModelWriter((AbstractModel)GIS.trainModel((EventStream)new CollectionEventStream(this.events), (int)100, (int)10), new File(this.modelName + this.modelExtension)).persist();
        }
    }
}

