/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.resolver;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.resolver.MaxentResolver;
import chalk.tools.coref.resolver.NonReferentialResolver;
import chalk.tools.coref.resolver.ResolverMode;
import chalk.tools.coref.resolver.ResolverUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DefiniteNounResolver
extends MaxentResolver {
    public DefiniteNounResolver(String string, ResolverMode resolverMode) throws IOException {
        super(string, "defmodel", resolverMode, 80);
    }

    public DefiniteNounResolver(String string, ResolverMode resolverMode, NonReferentialResolver nonReferentialResolver) throws IOException {
        super(string, "defmodel", resolverMode, 80, nonReferentialResolver);
    }

    @Override
    public boolean canResolve(MentionContext mentionContext) {
        Object[] objectArray = mentionContext.getTokens();
        String string = mentionContext.getFirstTokenText().toLowerCase();
        boolean bl = objectArray.length > 1 && !mentionContext.getHeadTokenTag().startsWith("NNP") && ResolverUtils.definiteArticle(string, mentionContext.getFirstTokenTag());
        return bl;
    }

    @Override
    protected List<String> getFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(super.getFeatures(mentionContext, discourseEntity));
        if (discourseEntity != null) {
            arrayList.addAll(ResolverUtils.getContextFeatures(mentionContext));
            arrayList.addAll(ResolverUtils.getStringMatchFeatures(mentionContext, discourseEntity));
            arrayList.addAll(ResolverUtils.getDistanceFeatures(mentionContext, discourseEntity));
        }
        return arrayList;
    }
}

