/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.resolver;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.resolver.MaxentResolver;
import chalk.tools.coref.resolver.NonReferentialResolver;
import chalk.tools.coref.resolver.ResolverMode;
import chalk.tools.coref.resolver.ResolverUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class IsAResolver
extends MaxentResolver {
    Pattern predicativePattern;

    public IsAResolver(String string, ResolverMode resolverMode) throws IOException {
        super(string, "/imodel", resolverMode, 20);
        this.showExclusions = false;
        this.predicativePattern = Pattern.compile("^(,|--)$");
    }

    public IsAResolver(String string, ResolverMode resolverMode, NonReferentialResolver nonReferentialResolver) throws IOException {
        super(string, "/imodel", resolverMode, 20, nonReferentialResolver);
        this.showExclusions = false;
        this.predicativePattern = Pattern.compile("^(,|--)$");
    }

    @Override
    public boolean canResolve(MentionContext mentionContext) {
        if (mentionContext.getHeadTokenTag().startsWith("NN")) {
            return mentionContext.getPreviousToken() != null && this.predicativePattern.matcher(((Object)mentionContext.getPreviousToken()).toString()).matches();
        }
        return false;
    }

    @Override
    protected boolean excluded(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        MentionContext mentionContext2 = discourseEntity.getLastExtent();
        if (mentionContext.getSentenceNumber() != mentionContext2.getSentenceNumber()) {
            return true;
        }
        if (mentionContext2.getIndexSpan().getEnd() == mentionContext.getIndexSpan().getStart() - 2) {
            return false;
        }
        if (mentionContext2.getIndexSpan().getEnd() == mentionContext.getIndexSpan().getEnd()) {
            return false;
        }
        return mentionContext2.getIndexSpan().getEnd() > mentionContext.getIndexSpan().getEnd() + 2 || mentionContext.getNextToken() == null || !((Object)mentionContext.getNextToken()).toString().equals(",") && !((Object)mentionContext.getNextToken()).toString().equals(".");
    }

    @Override
    protected boolean outOfRange(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        MentionContext mentionContext2 = discourseEntity.getLastExtent();
        return mentionContext2.getSentenceNumber() != mentionContext.getSentenceNumber();
    }

    @Override
    protected boolean defaultReferent(DiscourseEntity discourseEntity) {
        return true;
    }

    @Override
    protected List<String> getFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(super.getFeatures(mentionContext, discourseEntity));
        if (discourseEntity != null) {
            MentionContext mentionContext2 = discourseEntity.getLastExtent();
            List<String> list = ResolverUtils.getContextFeatures(mentionContext2);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add("l" + list.get(i));
            }
            List<String> list2 = ResolverUtils.getContextFeatures(mentionContext);
            int n2 = list2.size();
            for (n = 0; n < n2; ++n) {
                arrayList.add("r" + list2.get(n));
            }
            arrayList.add("hts" + mentionContext2.getHeadTokenTag() + "," + mentionContext.getHeadTokenTag());
        }
        return arrayList;
    }
}

