/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.resolver;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.DiscourseModel;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.resolver.AbstractResolver;
import chalk.tools.coref.resolver.DefaultNonReferentialResolver;
import chalk.tools.coref.resolver.FixedNonReferentialResolver;
import chalk.tools.coref.resolver.NonReferentialResolver;
import chalk.tools.coref.resolver.ResolverMode;
import chalk.tools.coref.resolver.ResolverUtils;
import chalk.tools.coref.sim.TestSimilarityModel;
import chalk.tools.util.CollectionEventStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nak.io.SuffixSensitiveGISModelReader;
import nak.io.SuffixSensitiveGISModelWriter;
import nak.maxent.GIS;
import nak.model.AbstractModel;
import nak.model.Event;
import nak.model.EventStream;
import nak.model.MaxentModel;

public abstract class MaxentResolver
extends AbstractResolver {
    public static final String SAME = "same";
    public static final String DIFF = "diff";
    public static final String DEFAULT = "default";
    private static boolean debugOn = false;
    private String modelName;
    private MaxentModel model;
    private double[] candProbs;
    private int sameIndex;
    private ResolverMode mode;
    private List<Event> events;
    protected boolean preferFirstReferent;
    protected boolean pairedSampleSelection;
    protected boolean useSameModelForNonRef;
    private static TestSimilarityModel simModel = null;
    protected NonReferentialResolver nonReferentialResolver;
    private static final String modelExtension = ".bin.gz";

    protected MaxentResolver(int n, boolean bl) {
        super(n);
        this.preferFirstReferent = bl;
    }

    public MaxentResolver(String string, String string2, ResolverMode resolverMode, int n, boolean bl, NonReferentialResolver nonReferentialResolver) throws IOException {
        super(n);
        this.preferFirstReferent = bl;
        this.nonReferentialResolver = nonReferentialResolver;
        this.mode = resolverMode;
        this.modelName = string + "/" + string2;
        if (ResolverMode.TEST == this.mode) {
            this.model = new SuffixSensitiveGISModelReader(new File(this.modelName + modelExtension)).getModel();
            this.sameIndex = this.model.getIndex(SAME);
        } else if (ResolverMode.TRAIN == this.mode) {
            this.events = new ArrayList<Event>();
        } else {
            System.err.println("Unknown mode: " + (Object)((Object)this.mode));
        }
        this.candProbs = new double[this.getNumEntities() + 1];
    }

    public MaxentResolver(String string, String string2, ResolverMode resolverMode, int n) throws IOException {
        this(string, string2, resolverMode, n, false);
    }

    public MaxentResolver(String string, String string2, ResolverMode resolverMode, int n, NonReferentialResolver nonReferentialResolver) throws IOException {
        this(string, string2, resolverMode, n, false, nonReferentialResolver);
    }

    public MaxentResolver(String string, String string2, ResolverMode resolverMode, int n, boolean bl) throws IOException {
        this(string, string2, resolverMode, n, bl, new DefaultNonReferentialResolver(string, string2, resolverMode));
    }

    public MaxentResolver(String string, String string2, ResolverMode resolverMode, int n, boolean bl, double d) throws IOException {
        this(string, string2, resolverMode, n, bl, new FixedNonReferentialResolver(d));
    }

    @Override
    public DiscourseEntity resolve(MentionContext mentionContext, DiscourseModel discourseModel) {
        DiscourseEntity discourseEntity;
        int n = 0;
        double d = this.nonReferentialResolver.getNonReferentialProbability(mentionContext);
        if (debugOn) {
            System.err.println(this + ".resolve: " + mentionContext.toText() + " -> " + "null " + d);
        }
        while (n < this.getNumEntities(discourseModel) && !this.outOfRange(mentionContext, discourseEntity = discourseModel.getEntity(n))) {
            if (this.excluded(mentionContext, discourseEntity)) {
                this.candProbs[n] = 0.0;
                if (debugOn) {
                    System.err.println("excluded " + this + ".resolve: " + mentionContext.toText() + " -> " + discourseEntity + " " + this.candProbs[n]);
                }
            } else {
                List<String> list = this.getFeatures(mentionContext, discourseEntity);
                String[] stringArray = list.toArray(new String[list.size()]);
                try {
                    this.candProbs[n] = this.model.eval(stringArray)[this.sameIndex];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.candProbs[n] = 0.0;
                }
                if (debugOn) {
                    System.err.println(this + ".resolve: " + mentionContext.toText() + " -> " + discourseEntity + " (" + mentionContext.getGender() + "," + discourseEntity.getGender() + ") " + this.candProbs[n] + " " + list);
                }
            }
            if (this.preferFirstReferent && this.candProbs[n] > d) {
                ++n;
                break;
            }
            ++n;
        }
        this.candProbs[n] = d;
        int n2 = 0;
        for (int i = 1; i <= n; ++i) {
            if (!(this.candProbs[i] > this.candProbs[n2])) continue;
            n2 = i;
        }
        if (n2 == n) {
            return null;
        }
        discourseEntity = discourseModel.getEntity(n2);
        return discourseEntity;
    }

    protected boolean defaultReferent(DiscourseEntity discourseEntity) {
        MentionContext mentionContext = discourseEntity.getLastExtent();
        return mentionContext.getNounPhraseSentenceIndex() == 0;
    }

    @Override
    public DiscourseEntity retain(MentionContext mentionContext, DiscourseModel discourseModel) {
        if (ResolverMode.TRAIN == this.mode) {
            DiscourseEntity discourseEntity = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < this.getNumEntities(discourseModel); ++i) {
                DiscourseEntity discourseEntity2 = discourseModel.getEntity(i);
                MentionContext mentionContext2 = discourseEntity2.getLastExtent();
                if (this.outOfRange(mentionContext, discourseEntity2)) {
                    if (mentionContext.getId() == -1 || bl) break;
                    break;
                }
                if (this.excluded(mentionContext, discourseEntity2)) {
                    if (this.showExclusions && mentionContext.getId() != -1 && mentionContext2.getId() == mentionContext.getId()) {
                        System.err.println(this + ".retain: Referent excluded: (" + mentionContext.getId() + ") " + mentionContext.toText() + " " + mentionContext.getIndexSpan() + " -> (" + mentionContext2.getId() + ") " + mentionContext2.toText() + " " + mentionContext2.getSpan() + " " + this);
                    }
                } else {
                    bl2 = true;
                    boolean bl4 = this.defaultReferent(discourseEntity2);
                    List<String> list = this.getFeatures(mentionContext, discourseEntity2);
                    if (debugOn) {
                        System.err.println(this + ".retain: " + mentionContext.getId() + " " + mentionContext.toText() + " -> " + mentionContext2.getId() + " " + discourseEntity2);
                    }
                    if (mentionContext.getId() != -1 && mentionContext2.getId() == mentionContext.getId()) {
                        bl = true;
                        this.events.add(new Event(SAME, list.toArray(new String[list.size()])));
                        discourseEntity = discourseEntity2;
                        this.distances.add(i);
                    } else if (!this.pairedSampleSelection || !bl3 && bl4) {
                        bl3 = true;
                        this.events.add(new Event(DIFF, list.toArray(new String[list.size()])));
                    }
                }
                if (this.pairedSampleSelection && bl && bl3 || this.preferFirstReferent && bl) break;
            }
            if (bl2) {
                this.nonReferentialResolver.addEvent(mentionContext);
            }
            return discourseEntity;
        }
        return super.retain(mentionContext, discourseModel);
    }

    protected List<String> getFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DEFAULT);
        arrayList.addAll(ResolverUtils.getCompatibilityFeatures(mentionContext, discourseEntity, simModel));
        return arrayList;
    }

    @Override
    public void train() throws IOException {
        if (ResolverMode.TRAIN == this.mode) {
            if (debugOn) {
                System.err.println(this + " referential");
                FileWriter fileWriter = new FileWriter(this.modelName + ".events");
                for (Event event : this.events) {
                    fileWriter.write(event.toString() + "\n");
                }
                fileWriter.close();
            }
            new SuffixSensitiveGISModelWriter((AbstractModel)GIS.trainModel((EventStream)new CollectionEventStream(this.events), (int)100, (int)10), new File(this.modelName + modelExtension)).persist();
            this.nonReferentialResolver.train();
        }
    }

    public static void setSimilarityModel(TestSimilarityModel testSimilarityModel) {
        simModel = testSimilarityModel;
    }

    @Override
    protected boolean excluded(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        return super.excluded(mentionContext, discourseEntity);
    }
}

