/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.resolver;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.resolver.MaxentResolver;
import chalk.tools.coref.resolver.NonReferentialResolver;
import chalk.tools.coref.resolver.ResolverMode;
import chalk.tools.coref.resolver.ResolverUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PluralNounResolver
extends MaxentResolver {
    public PluralNounResolver(String string, ResolverMode resolverMode) throws IOException {
        super(string, "plmodel", resolverMode, 80, true);
        this.showExclusions = false;
    }

    public PluralNounResolver(String string, ResolverMode resolverMode, NonReferentialResolver nonReferentialResolver) throws IOException {
        super(string, "plmodel", resolverMode, 80, true, nonReferentialResolver);
        this.showExclusions = false;
    }

    @Override
    protected List<String> getFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(super.getFeatures(mentionContext, discourseEntity));
        if (discourseEntity != null) {
            arrayList.addAll(ResolverUtils.getContextFeatures(mentionContext));
            arrayList.addAll(ResolverUtils.getStringMatchFeatures(mentionContext, discourseEntity));
        }
        return arrayList;
    }

    @Override
    public boolean canResolve(MentionContext mentionContext) {
        String string = mentionContext.getFirstTokenText().toLowerCase();
        String string2 = mentionContext.getFirstToken().getSyntacticType();
        boolean bl = mentionContext.getHeadTokenTag().equals("NNS") && !ResolverUtils.definiteArticle(string, string2);
        return bl;
    }

    @Override
    protected boolean excluded(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        if (super.excluded(mentionContext, discourseEntity)) {
            return true;
        }
        MentionContext mentionContext2 = discourseEntity.getLastExtent();
        return !mentionContext2.getHeadTokenTag().equals("NNS") || super.excluded(mentionContext, discourseEntity);
    }
}

