/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.resolver;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.resolver.MaxentResolver;
import chalk.tools.coref.resolver.NonReferentialResolver;
import chalk.tools.coref.resolver.ResolverMode;
import chalk.tools.coref.resolver.ResolverUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PluralPronounResolver
extends MaxentResolver {
    int NUM_SENTS_BACK_PRONOUNS = 2;

    public PluralPronounResolver(String string, ResolverMode resolverMode) throws IOException {
        super(string, "tmodel", resolverMode, 30);
    }

    public PluralPronounResolver(String string, ResolverMode resolverMode, NonReferentialResolver nonReferentialResolver) throws IOException {
        super(string, "tmodel", resolverMode, 30, nonReferentialResolver);
    }

    @Override
    protected List<String> getFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(super.getFeatures(mentionContext, discourseEntity));
        if (discourseEntity != null) {
            arrayList.addAll(ResolverUtils.getPronounMatchFeatures(mentionContext, discourseEntity));
            MentionContext mentionContext2 = discourseEntity.getLastExtent();
            arrayList.addAll(ResolverUtils.getDistanceFeatures(mentionContext, discourseEntity));
            arrayList.addAll(ResolverUtils.getContextFeatures(mentionContext2));
            arrayList.add(ResolverUtils.getMentionCountFeature(discourseEntity));
        }
        return arrayList;
    }

    @Override
    protected boolean outOfRange(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        MentionContext mentionContext2 = discourseEntity.getLastExtent();
        return mentionContext.getSentenceNumber() - mentionContext2.getSentenceNumber() > this.NUM_SENTS_BACK_PRONOUNS;
    }

    @Override
    public boolean canResolve(MentionContext mentionContext) {
        String string = mentionContext.getHeadTokenTag();
        return string != null && string.startsWith("PRP") && ResolverUtils.pluralThirdPersonPronounPattern.matcher(mentionContext.getHeadTokenText()).matches();
    }
}

