/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.resolver;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.resolver.MaxentResolver;
import chalk.tools.coref.resolver.NonReferentialResolver;
import chalk.tools.coref.resolver.ResolverMode;
import chalk.tools.coref.resolver.ResolverUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ProperNounResolver
extends MaxentResolver {
    private static Map<String, Set<String>> acroMap;
    private static boolean acroMapLoaded;

    public ProperNounResolver(String string, ResolverMode resolverMode) throws IOException {
        super(string, "pnmodel", resolverMode, 500);
        if (!acroMapLoaded) {
            this.initAcronyms(string + "/acronyms");
            acroMapLoaded = true;
        }
        this.showExclusions = false;
    }

    public ProperNounResolver(String string, ResolverMode resolverMode, NonReferentialResolver nonReferentialResolver) throws IOException {
        super(string, "pnmodel", resolverMode, 500, nonReferentialResolver);
        if (!acroMapLoaded) {
            this.initAcronyms(string + "/acronyms");
            acroMapLoaded = true;
        }
        this.showExclusions = false;
    }

    @Override
    public boolean canResolve(MentionContext mentionContext) {
        return mentionContext.getHeadTokenTag().startsWith("NNP") || mentionContext.getHeadTokenTag().startsWith("CD");
    }

    private void initAcronyms(String string) {
        acroMap = new HashMap<String, Set<String>>(15000);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while (null != (string2 = bufferedReader.readLine())) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                Set<String> set = acroMap.get(string3);
                if (set == null) {
                    set = new HashSet<String>();
                    acroMap.put(string3, set);
                }
                set.add(string4);
                set = acroMap.get(string4);
                if (set == null) {
                    set = new HashSet<String>();
                    acroMap.put(string4, set);
                }
                set.add(string3);
            }
        }
        catch (IOException iOException) {
            System.err.println("ProperNounResolver.initAcronyms: Acronym Database not found: " + iOException);
        }
    }

    private boolean isAcronym(String string, String string2) {
        Set<String> set = acroMap.get(string);
        return set != null && set.contains(string2);
    }

    protected List<String> getAcronymFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        MentionContext mentionContext2 = ResolverUtils.getProperNounExtent(discourseEntity);
        String string = ResolverUtils.stripNp(mentionContext);
        String string2 = ResolverUtils.stripNp(mentionContext2);
        if (string != null && string2 != null && this.isAcronym(string, string2)) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add("knownAcronym");
            return arrayList;
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(super.getFeatures(mentionContext, discourseEntity));
        if (discourseEntity != null) {
            arrayList.addAll(ResolverUtils.getStringMatchFeatures(mentionContext, discourseEntity));
            arrayList.addAll(this.getAcronymFeatures(mentionContext, discourseEntity));
        }
        return arrayList;
    }

    @Override
    public boolean excluded(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        if (super.excluded(mentionContext, discourseEntity)) {
            return true;
        }
        Iterator<MentionContext> iterator = discourseEntity.getMentions();
        while (iterator.hasNext()) {
            MentionContext mentionContext2 = iterator.next();
            if (!mentionContext2.getHeadTokenTag().startsWith("NNP")) continue;
            return false;
        }
        return true;
    }

    static {
        acroMapLoaded = false;
    }
}

