/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.resolver;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.mention.Parse;
import chalk.tools.coref.sim.GenderEnum;
import chalk.tools.coref.sim.NumberEnum;
import chalk.tools.coref.sim.TestSimilarityModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ResolverUtils {
    private static final Pattern ENDS_WITH_PERIOD = Pattern.compile("\\.$");
    private static final Pattern initialCaps = Pattern.compile("^[A-Z]");
    public static final Pattern singularThirdPersonPronounPattern = Pattern.compile("^(he|she|it|him|her|his|hers|its|himself|herself|itself)$", 2);
    public static final Pattern pluralThirdPersonPronounPattern = Pattern.compile("^(they|their|theirs|them|themselves)$", 2);
    public static final Pattern speechPronounPattern = Pattern.compile("^(I|me|my|you|your|you|we|us|our|ours)$", 2);
    public static final Pattern femalePronounPattern = Pattern.compile("^(she|her|hers|herself)$", 2);
    public static final Pattern neuterPronounPattern = Pattern.compile("^(it|its|itself)$", 2);
    public static final Pattern firstPersonPronounPattern = Pattern.compile("^(I|me|my|we|our|us|ours)$", 2);
    public static final Pattern secondPersonPronounPattern = Pattern.compile("^(you|your|yours)$", 2);
    public static final Pattern thirdPersonPronounPattern = Pattern.compile("^(he|she|it|him|her|his|hers|its|himself|herself|itself|they|their|theirs|them|themselves)$", 2);
    public static final Pattern singularPronounPattern = Pattern.compile("^(I|me|my|he|she|it|him|her|his|hers|its|himself|herself|itself)$", 2);
    public static final Pattern pluralPronounPattern = Pattern.compile("^(we|us|our|ours|they|their|theirs|them|themselves)$", 2);
    public static final Pattern malePronounPattern = Pattern.compile("^(he|him|his|himself)$", 2);
    public static final Pattern honorificsPattern = Pattern.compile("[A-Z][a-z]+\\.$|^[A-Z][b-df-hj-np-tv-xz]+$");
    public static final Pattern designatorsPattern = Pattern.compile("[a-z]\\.$|^[A-Z][b-df-hj-np-tv-xz]+$|^Co(rp)?$");
    private static final String NUM_COMPATIBLE = "num.compatible";
    private static final String NUM_INCOMPATIBLE = "num.incompatible";
    private static final String NUM_UNKNOWN = "num.unknown";
    private static final String GEN_COMPATIBLE = "gen.compatible";
    private static final String GEN_INCOMPATIBLE = "gen.incompatible";
    private static final String GEN_UNKNOWN = "gen.unknown";
    private static final String SIM_COMPATIBLE = "sim.compatible";
    private static final String SIM_INCOMPATIBLE = "sim.incompatible";
    private static final String SIM_UNKNOWN = "sim.unknown";
    private static final double MIN_SIM_PROB = 0.6;

    public static List<String> getContextFeatures(MentionContext mentionContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (mentionContext.getPreviousToken() != null) {
            arrayList.add("pt=" + mentionContext.getPreviousToken().getSyntacticType());
            arrayList.add("pw=" + ((Object)mentionContext.getPreviousToken()).toString());
        } else {
            arrayList.add("pt=BOS");
            arrayList.add("pw=BOS");
        }
        if (mentionContext.getNextToken() != null) {
            arrayList.add("nt=" + mentionContext.getNextToken().getSyntacticType());
            arrayList.add("nw=" + ((Object)mentionContext.getNextToken()).toString());
        } else {
            arrayList.add("nt=EOS");
            arrayList.add("nw=EOS");
        }
        if (mentionContext.getNextTokenBasal() != null) {
            arrayList.add("bnt=" + mentionContext.getNextTokenBasal().getSyntacticType());
            arrayList.add("bnw=" + ((Object)mentionContext.getNextTokenBasal()).toString());
        } else {
            arrayList.add("bnt=EOS");
            arrayList.add("bnw=EOS");
        }
        return arrayList;
    }

    public static List<String> getWordFeatures(Parse parse) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = ((Object)parse).toString().toLowerCase();
        String string2 = "";
        if (ENDS_WITH_PERIOD.matcher(string).find()) {
            string2 = ",endWithPeriod";
        }
        String string3 = parse.getSyntacticType();
        arrayList.add("w=" + string + ",t=" + string3 + string2);
        arrayList.add("t=" + string3 + string2);
        return arrayList;
    }

    public static Set<String> constructModifierSet(Parse[] parseArray, int n) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            Parse parse = parseArray[i];
            hashSet.add(((Object)parse).toString().toLowerCase());
        }
        return hashSet;
    }

    public static String excludedDeterminerMentionString(MentionContext mentionContext) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Parse parse : mentionContext.getTokenParses()) {
            String string = parse.getSyntacticType();
            if (string.equals("DT")) continue;
            if (!bl) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(((Object)parse).toString());
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static String excludedHonorificMentionString(MentionContext mentionContext) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        Object[] objectArray = mentionContext.getTokens();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string = objectArray[i].toString();
            if (honorificsPattern.matcher(string).matches()) continue;
            if (!bl) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static String excludedTheMentionString(MentionContext mentionContext) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        Object[] objectArray = mentionContext.getTokens();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string = objectArray[i].toString();
            if (string.equals("the") || string.equals("The") || string.equals("THE")) continue;
            if (!bl) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static String getExactMatchFeature(MentionContext mentionContext, MentionContext mentionContext2) {
        if (ResolverUtils.mentionString(mentionContext).equals(ResolverUtils.mentionString(mentionContext2))) {
            return "exactMatch";
        }
        if (ResolverUtils.excludedHonorificMentionString(mentionContext).equals(ResolverUtils.excludedHonorificMentionString(mentionContext2))) {
            return "exactMatchNoHonor";
        }
        if (ResolverUtils.excludedTheMentionString(mentionContext).equals(ResolverUtils.excludedTheMentionString(mentionContext2))) {
            return "exactMatchNoThe";
        }
        if (ResolverUtils.excludedDeterminerMentionString(mentionContext).equals(ResolverUtils.excludedDeterminerMentionString(mentionContext2))) {
            return "exactMatchNoDT";
        }
        return null;
    }

    public static List<String> getStringMatchFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        Parse[] parseArray = mentionContext.getTokenParses();
        Set<String> set = ResolverUtils.constructModifierSet(parseArray, mentionContext.getHeadTokenIndex());
        String string = mentionContext.getHeadTokenText().toLowerCase();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<MentionContext> iterator = discourseEntity.getMentions();
        while (iterator.hasNext()) {
            Set<String> set2;
            Parse[] parseArray2;
            MentionContext mentionContext2 = iterator.next();
            String string2 = ResolverUtils.getExactMatchFeature(mentionContext2, mentionContext);
            if (string2 != null) {
                hashSet.add(string2);
            } else if (mentionContext2.getParse().isCoordinatedNounPhrase() && !mentionContext.getParse().isCoordinatedNounPhrase()) {
                hashSet.add("cmix");
            } else {
                parseArray2 = ResolverUtils.stripNp(mentionContext);
                String string3 = ResolverUtils.stripNp(mentionContext2);
                if (parseArray2 != null && string3 != null && ResolverUtils.isSubstring((String)parseArray2, string3)) {
                    hashSet.add("substring");
                }
            }
            parseArray2 = mentionContext2.getTokenParses();
            int n = mentionContext2.getHeadTokenIndex();
            String string4 = mentionContext2.getHeadTokenText().toLowerCase();
            if (string.equals(string4)) {
                bl = true;
                hashSet.add("hds=" + string);
                if (!bl2 || !bl4) {
                    bl2 = true;
                    bl4 = true;
                    set2 = ResolverUtils.constructModifierSet(parseArray2, n);
                    for (String string5 : set) {
                        if (set2.contains(string5)) continue;
                        bl2 = false;
                        if (string5.equals("the")) continue;
                        bl4 = false;
                        hashSet.add("mmw=" + string5);
                    }
                }
            }
            if (!(set2 = ResolverUtils.constructModifierSet(parseArray2, mentionContext2.getNonDescriptorStart())).contains(string)) continue;
            bl3 = true;
        }
        if (!hashSet.isEmpty()) {
            arrayList.addAll(hashSet);
        }
        if (bl) {
            arrayList.add("sameHead");
            if (bl2) {
                arrayList.add("modsMatch");
            } else if (bl4) {
                arrayList.add("nonTheModsMatch");
            } else {
                arrayList.add("modsMisMatch");
            }
        }
        if (bl3) {
            arrayList.add("titleMatch");
        }
        return arrayList;
    }

    public static boolean isSubstring(String string, String string2) {
        int n = string2.indexOf(string);
        if (n != -1) {
            if (n != 0 && string2.charAt(n - 1) != ' ') {
                return false;
            }
            int n2 = n + string.length();
            return n2 == string2.length() || string2.charAt(n2) == ' ';
        }
        return false;
    }

    public static String mentionString(MentionContext mentionContext) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = mentionContext.getTokens();
        stringBuilder.append(objectArray[0].toString());
        int n = objectArray.length;
        for (int i = 1; i < n; ++i) {
            String string = objectArray[i].toString();
            stringBuilder.append(" ").append(string);
        }
        return stringBuilder.toString();
    }

    public static String stripNp(MentionContext mentionContext) {
        String string;
        int n = mentionContext.getNonDescriptorStart();
        Parse[] parseArray = mentionContext.getTokenParses();
        int n2 = mentionContext.getHeadTokenIndex() + 1;
        if (n == n2) {
            return null;
        }
        if (parseArray[n].getSyntacticType().equals("DT")) {
            ++n;
        }
        if (n == n2) {
            return null;
        }
        for (int i = n; i < n2 && !(string = parseArray[n].getSyntacticType()).startsWith("NNP"); ++i) {
            ++n;
        }
        if (n == n2) {
            return null;
        }
        if (n + 1 != n2) {
            if (honorificsPattern.matcher(((Object)parseArray[n]).toString()).find()) {
                ++n;
            }
            if (n == n2) {
                return null;
            }
            if (designatorsPattern.matcher(((Object)parseArray[parseArray.length - 1]).toString()).find()) {
                --n2;
            }
        }
        if (n == n2) {
            return null;
        }
        String string2 = "";
        for (int i = n; i < n2; ++i) {
            string2 = string2 + ((Object)parseArray[i]).toString() + ' ';
        }
        return string2.trim();
    }

    public static MentionContext getProperNounExtent(DiscourseEntity discourseEntity) {
        Iterator<MentionContext> iterator = discourseEntity.getMentions();
        while (iterator.hasNext()) {
            MentionContext mentionContext = iterator.next();
            String string = mentionContext.getHeadTokenTag();
            if (!string.startsWith("NNP") && !initialCaps.matcher(mentionContext.getHeadTokenText()).find()) continue;
            return mentionContext;
        }
        return null;
    }

    private static Map<String, String> getPronounFeatureMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (malePronounPattern.matcher(string).matches()) {
            hashMap.put("gender", "male");
        } else if (femalePronounPattern.matcher(string).matches()) {
            hashMap.put("gender", "female");
        } else if (neuterPronounPattern.matcher(string).matches()) {
            hashMap.put("gender", "neuter");
        }
        if (singularPronounPattern.matcher(string).matches()) {
            hashMap.put("number", "singular");
        } else if (pluralPronounPattern.matcher(string).matches()) {
            hashMap.put("number", "plural");
        }
        return hashMap;
    }

    public static List<String> getPronounMatchFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        if (mentionContext.getHeadTokenTag().startsWith("PRP")) {
            object = ResolverUtils.getPronounFeatureMap(mentionContext.getHeadTokenText());
            Iterator<MentionContext> iterator = discourseEntity.getMentions();
            while (iterator.hasNext()) {
                MentionContext mentionContext2 = iterator.next();
                if (!mentionContext2.getHeadTokenTag().startsWith("PRP")) continue;
                if (mentionContext.getHeadTokenText().equalsIgnoreCase(mentionContext2.getHeadTokenText())) {
                    bl = true;
                    break;
                }
                Map<String, String> map = ResolverUtils.getPronounFeatureMap(mentionContext2.getHeadTokenText());
                boolean bl3 = true;
                for (String string : object.keySet()) {
                    String string2 = map.get(string);
                    if (string2 != null) {
                        if (((String)object.get(string)).equals(string2)) continue;
                        bl2 = true;
                        bl3 = false;
                        continue;
                    }
                    bl3 = false;
                }
                if (!bl3) continue;
                bl = true;
            }
        }
        object = new ArrayList();
        if (bl) {
            object.add("compatiblePronoun");
        }
        if (bl2) {
            object.add("incompatiblePronoun");
        }
        return object;
    }

    public static List<String> getDistanceFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MentionContext mentionContext2 = discourseEntity.getLastExtent();
        int n = mentionContext.getNounPhraseDocumentIndex() - mentionContext2.getNounPhraseDocumentIndex();
        int n2 = mentionContext.getSentenceNumber() - mentionContext2.getSentenceNumber();
        int n3 = n2 == 0 ? mentionContext2.getNounPhraseSentenceIndex() : n + 2 * mentionContext2.getNounPhraseSentenceIndex() - mentionContext2.getMaxNounPhraseSentenceIndex();
        arrayList.add("hd=" + n3);
        arrayList.add("de=" + n);
        arrayList.add("ds=" + n2);
        return arrayList;
    }

    public static boolean definiteArticle(String string, String string2) {
        return (string = string.toLowerCase()).equals("the") || string.equals("these") || string.equals("these") || string2.equals("PRP$");
    }

    public static String getNumberCompatibilityFeature(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        NumberEnum numberEnum = discourseEntity.getNumber();
        if (numberEnum == NumberEnum.UNKNOWN || mentionContext.getNumber() == NumberEnum.UNKNOWN) {
            return NUM_UNKNOWN;
        }
        if (mentionContext.getNumber() == numberEnum) {
            return NUM_COMPATIBLE;
        }
        return NUM_INCOMPATIBLE;
    }

    public static List<String> getCompatibilityFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity, TestSimilarityModel testSimilarityModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = ResolverUtils.getSemanticCompatibilityFeature(mentionContext, discourseEntity, testSimilarityModel);
        arrayList.add(string);
        String string2 = ResolverUtils.getGenderCompatibilityFeature(mentionContext, discourseEntity);
        arrayList.add(string2);
        String string3 = ResolverUtils.getNumberCompatibilityFeature(mentionContext, discourseEntity);
        arrayList.add(string3);
        if (string.equals(SIM_COMPATIBLE) && string2.equals(GEN_COMPATIBLE) && string3.equals(NUM_COMPATIBLE)) {
            arrayList.add("all.compatible");
        } else if (string.equals(SIM_INCOMPATIBLE) || string2.equals(GEN_INCOMPATIBLE) || string3.equals(NUM_INCOMPATIBLE)) {
            arrayList.add("some.incompatible");
        }
        return arrayList;
    }

    public static String getGenderCompatibilityFeature(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        GenderEnum genderEnum = discourseEntity.getGender();
        if (genderEnum == GenderEnum.UNKNOWN || mentionContext.getGender() == GenderEnum.UNKNOWN) {
            return GEN_UNKNOWN;
        }
        if (mentionContext.getGender() == genderEnum) {
            return GEN_COMPATIBLE;
        }
        return GEN_INCOMPATIBLE;
    }

    public static String getSemanticCompatibilityFeature(MentionContext mentionContext, DiscourseEntity discourseEntity, TestSimilarityModel testSimilarityModel) {
        if (testSimilarityModel != null) {
            double d = 0.0;
            Iterator<MentionContext> iterator = discourseEntity.getMentions();
            while (iterator.hasNext()) {
                MentionContext mentionContext2 = iterator.next();
                double d2 = testSimilarityModel.compatible(mentionContext, mentionContext2);
                if (!(d2 > d)) continue;
                d = d2;
            }
            if (d > 0.6) {
                return SIM_COMPATIBLE;
            }
            if (d > 0.4) {
                return SIM_UNKNOWN;
            }
            return SIM_INCOMPATIBLE;
        }
        System.err.println("MaxentResolver: Uninitialized Semantic Model");
        return SIM_UNKNOWN;
    }

    public static String getMentionCountFeature(DiscourseEntity discourseEntity) {
        if (discourseEntity.getNumMentions() >= 5) {
            return "mc=5+";
        }
        return "mc=" + discourseEntity.getNumMentions();
    }

    public static String getPronounGender(String string) {
        if (malePronounPattern.matcher(string).matches()) {
            return "m";
        }
        if (femalePronounPattern.matcher(string).matches()) {
            return "f";
        }
        if (neuterPronounPattern.matcher(string).matches()) {
            return "n";
        }
        return "u";
    }
}

