/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.resolver;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.resolver.MaxentResolver;
import chalk.tools.coref.resolver.NonReferentialResolver;
import chalk.tools.coref.resolver.ResolverMode;
import chalk.tools.coref.resolver.ResolverUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class SingularPronounResolver
extends MaxentResolver {
    int mode;
    Pattern PronounPattern;

    public SingularPronounResolver(String string, ResolverMode resolverMode) throws IOException {
        super(string, "pmodel", resolverMode, 30);
        this.numSentencesBack = 2;
    }

    public SingularPronounResolver(String string, ResolverMode resolverMode, NonReferentialResolver nonReferentialResolver) throws IOException {
        super(string, "pmodel", resolverMode, 30, nonReferentialResolver);
        this.numSentencesBack = 2;
    }

    @Override
    public boolean canResolve(MentionContext mentionContext) {
        String string = mentionContext.getHeadTokenTag();
        return string != null && string.startsWith("PRP") && ResolverUtils.singularThirdPersonPronounPattern.matcher(mentionContext.getHeadTokenText()).matches();
    }

    @Override
    protected List<String> getFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(super.getFeatures(mentionContext, discourseEntity));
        if (discourseEntity != null) {
            MentionContext mentionContext2 = discourseEntity.getLastExtent();
            arrayList.addAll(ResolverUtils.getPronounMatchFeatures(mentionContext, discourseEntity));
            arrayList.addAll(ResolverUtils.getContextFeatures(mentionContext2));
            arrayList.addAll(ResolverUtils.getDistanceFeatures(mentionContext, discourseEntity));
            arrayList.add(ResolverUtils.getMentionCountFeature(discourseEntity));
        }
        return arrayList;
    }

    @Override
    public boolean excluded(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        if (super.excluded(mentionContext, discourseEntity)) {
            return true;
        }
        String string = null;
        Iterator<MentionContext> iterator = discourseEntity.getMentions();
        while (iterator.hasNext()) {
            String string2;
            MentionContext mentionContext2 = iterator.next();
            String string3 = mentionContext2.getHeadTokenTag();
            if (string3 == null || !string3.startsWith("PRP") || !ResolverUtils.singularThirdPersonPronounPattern.matcher(mentionContext.getHeadTokenText()).matches()) continue;
            if (string == null) {
                string = ResolverUtils.getPronounGender(mentionContext.getHeadTokenText());
            }
            if ((string2 = ResolverUtils.getPronounGender(mentionContext2.getHeadTokenText())).equals("u") || string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean outOfRange(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        MentionContext mentionContext2 = discourseEntity.getLastExtent();
        return mentionContext.getSentenceNumber() - mentionContext2.getSentenceNumber() > this.numSentencesBack;
    }
}

