/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.resolver;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.resolver.MaxentResolver;
import chalk.tools.coref.resolver.NonReferentialResolver;
import chalk.tools.coref.resolver.ResolverMode;
import chalk.tools.coref.resolver.ResolverUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SpeechPronounResolver
extends MaxentResolver {
    public SpeechPronounResolver(String string, ResolverMode resolverMode) throws IOException {
        super(string, "fmodel", resolverMode, 30);
        this.numSentencesBack = 0;
        this.showExclusions = false;
        this.preferFirstReferent = true;
    }

    public SpeechPronounResolver(String string, ResolverMode resolverMode, NonReferentialResolver nonReferentialResolver) throws IOException {
        super(string, "fmodel", resolverMode, 30, nonReferentialResolver);
        this.showExclusions = false;
        this.preferFirstReferent = true;
    }

    @Override
    protected List<String> getFeatures(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(super.getFeatures(mentionContext, discourseEntity));
        if (discourseEntity != null) {
            arrayList.addAll(ResolverUtils.getPronounMatchFeatures(mentionContext, discourseEntity));
            List<String> list = ResolverUtils.getContextFeatures(mentionContext);
            MentionContext mentionContext2 = discourseEntity.getLastExtent();
            if (mentionContext.getHeadTokenTag().startsWith("PRP") && mentionContext2.getHeadTokenTag().startsWith("PRP")) {
                arrayList.add(mentionContext.getHeadTokenText() + "," + mentionContext2.getHeadTokenText());
            } else if (mentionContext.getHeadTokenText().startsWith("NNP")) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(list.get(i));
                }
                arrayList.add(mentionContext.getNameType() + "," + mentionContext2.getHeadTokenText());
            } else {
                List<String> list2 = ResolverUtils.getContextFeatures(mentionContext2);
                int n = list2.size();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(list2.get(i));
                }
                arrayList.add(mentionContext2.getNameType() + "," + mentionContext.getHeadTokenText());
            }
        }
        return arrayList;
    }

    @Override
    protected boolean outOfRange(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        MentionContext mentionContext2 = discourseEntity.getLastExtent();
        return mentionContext.getSentenceNumber() - mentionContext2.getSentenceNumber() > this.numSentencesBack;
    }

    @Override
    public boolean canResolve(MentionContext mentionContext) {
        String string = mentionContext.getHeadTokenTag();
        boolean bl = string != null && string.startsWith("PRP") && ResolverUtils.speechPronounPattern.matcher(mentionContext.getHeadTokenText()).matches();
        boolean bl2 = string != null && string.startsWith("NNP");
        return bl || bl2;
    }

    @Override
    protected boolean excluded(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        if (super.excluded(mentionContext, discourseEntity)) {
            return true;
        }
        MentionContext mentionContext2 = discourseEntity.getLastExtent();
        if (!this.canResolve(mentionContext2)) {
            return true;
        }
        if (mentionContext.getHeadTokenTag().startsWith("NNP")) {
            if (mentionContext2.getHeadTokenTag().startsWith("NNP")) {
                return true;
            }
            if (discourseEntity.getNumMentions() > 1) {
                return true;
            }
            return !this.canResolve(mentionContext2);
        }
        if (mentionContext.getHeadTokenTag().startsWith("PRP")) {
            if (mentionContext2.getHeadTokenTag().startsWith("NNP")) {
                return mentionContext.getSentenceNumber() - mentionContext2.getSentenceNumber() != 0;
            }
            if (mentionContext2.getHeadTokenTag().startsWith("PRP")) {
                return false;
            }
            System.err.println("Unexpected candidate exluded: " + mentionContext2.toText());
            return true;
        }
        System.err.println("Unexpected mention exluded: " + mentionContext.toText());
        return true;
    }
}

