/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.sim;

import chalk.tools.coref.mention.Dictionary;
import chalk.tools.coref.mention.DictionaryFactory;
import chalk.tools.coref.mention.HeadFinder;
import chalk.tools.coref.mention.Mention;
import chalk.tools.coref.mention.Parse;
import chalk.tools.util.Span;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Context
extends Mention {
    protected String headTokenText;
    protected String headTokenTag;
    protected Set<String> synsets;
    protected Object[] tokens;
    protected int headTokenIndex;

    public Context(Span span, Span span2, int n, Parse parse, String string, String string2, HeadFinder headFinder) {
        super(span, span2, n, parse, string, string2);
        this.init(headFinder);
    }

    public Context(Object[] objectArray, String string, String string2, String string3) {
        super(null, null, 1, null, null, string3);
        this.tokens = objectArray;
        this.headTokenIndex = objectArray.length - 1;
        this.headTokenText = string;
        this.headTokenTag = string2;
        this.synsets = Context.getSynsetSet(this);
    }

    public Context(Mention mention, HeadFinder headFinder) {
        super(mention);
        this.init(headFinder);
    }

    private void init(HeadFinder headFinder) {
        Parse parse = headFinder.getLastHead(this.parse);
        List<Parse> list = parse.getTokens();
        this.headTokenIndex = headFinder.getHeadIndex(parse);
        Parse parse2 = headFinder.getHeadToken(parse);
        this.tokens = list.toArray(new Parse[list.size()]);
        this.headTokenTag = parse2.getSyntacticType();
        this.headTokenText = ((Object)parse2).toString();
        this.synsets = this.headTokenTag.startsWith("NN") && !this.headTokenTag.startsWith("NNP") ? Context.getSynsetSet(this) : Collections.emptySet();
    }

    public static Context[] constructContexts(Mention[] mentionArray, HeadFinder headFinder) {
        Context[] contextArray = new Context[mentionArray.length];
        for (int i = 0; i < mentionArray.length; ++i) {
            contextArray[i] = new Context(mentionArray[i], headFinder);
        }
        return contextArray;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.tokens.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.tokens[i]).append(" ");
        }
        return stringBuilder.toString();
    }

    public Object[] getTokens() {
        return this.tokens;
    }

    public String getHeadTokenText() {
        return this.headTokenText;
    }

    public String getHeadTokenTag() {
        return this.headTokenTag;
    }

    public Set<String> getSynsets() {
        return this.synsets;
    }

    public static Context parseContext(String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length == 2) {
            Object[] objectArray = stringArray[0].split(" ");
            return new Context(objectArray, objectArray[objectArray.length - 1], stringArray[1], null);
        }
        if (stringArray.length == 3) {
            Object[] objectArray = stringArray[0].split(" ");
            return new Context(objectArray, objectArray[objectArray.length - 1], stringArray[1], stringArray[2]);
        }
        return null;
    }

    private static Set<String> getSynsetSet(Context context) {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = Context.getLemmas(context);
        Dictionary dictionary = DictionaryFactory.getDictionary();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = dictionary.getSenseKey(stringArray[i], "NN", 0);
            if (string == null) continue;
            hashSet.add(string);
            String[] stringArray2 = dictionary.getParentSenseKeys(stringArray[i], "NN", 0);
            int n = stringArray2.length;
            for (int j = 0; j < n; ++j) {
                hashSet.add(stringArray2[j]);
            }
        }
        return hashSet;
    }

    private static String[] getLemmas(Context context) {
        String string = context.headTokenText.toLowerCase();
        return DictionaryFactory.getDictionary().getLemmas(string, "NN");
    }

    public int getHeadTokenIndex() {
        return this.headTokenIndex;
    }
}

