/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.sim;

import chalk.tools.coref.resolver.ResolverUtils;
import chalk.tools.coref.sim.Context;
import chalk.tools.coref.sim.GenderEnum;
import chalk.tools.coref.sim.TestGenderModel;
import chalk.tools.coref.sim.TrainSimilarityModel;
import chalk.tools.util.CollectionEventStream;
import chalk.tools.util.HashList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nak.io.SuffixSensitiveGISModelReader;
import nak.io.SuffixSensitiveGISModelWriter;
import nak.maxent.GIS;
import nak.model.AbstractModel;
import nak.model.Event;
import nak.model.EventStream;
import nak.model.MaxentModel;

public class GenderModel
implements TestGenderModel,
TrainSimilarityModel {
    private int maleIndex;
    private int femaleIndex;
    private int neuterIndex;
    private String modelName;
    private String modelExtension = ".bin.gz";
    private MaxentModel testModel;
    private List<Event> events;
    private boolean debugOn = true;
    private Set<String> maleNames;
    private Set<String> femaleNames;

    public static TestGenderModel testModel(String string) throws IOException {
        GenderModel genderModel = new GenderModel(string, false);
        return genderModel;
    }

    public static TrainSimilarityModel trainModel(String string) throws IOException {
        GenderModel genderModel = new GenderModel(string, true);
        return genderModel;
    }

    private Set<String> readNames(String string) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            hashSet.add(string2);
            string2 = bufferedReader.readLine();
        }
        return hashSet;
    }

    private GenderModel(String string, boolean bl) throws IOException {
        this.modelName = string;
        this.maleNames = this.readNames(string + ".mas");
        this.femaleNames = this.readNames(string + ".fem");
        if (bl) {
            this.events = new ArrayList<Event>();
        } else {
            this.testModel = new SuffixSensitiveGISModelReader(new File(string + this.modelExtension)).getModel();
            this.maleIndex = this.testModel.getIndex(GenderEnum.MALE.toString());
            this.femaleIndex = this.testModel.getIndex(GenderEnum.FEMALE.toString());
            this.neuterIndex = this.testModel.getIndex(GenderEnum.NEUTER.toString());
        }
    }

    private List<String> getFeatures(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("default");
        int n = context.getHeadTokenIndex();
        for (int i = 0; i < n; ++i) {
            arrayList.add("mw=" + context.getTokens()[i].toString());
        }
        arrayList.add("hw=" + context.getHeadTokenText());
        arrayList.add("n=" + context.getNameType());
        if (context.getNameType() != null && context.getNameType().equals("person")) {
            Object[] objectArray = context.getTokens();
            for (n = 0; n < context.getHeadTokenIndex() || n == 0; ++n) {
                String string = objectArray[n].toString().toLowerCase();
                if (this.femaleNames.contains(string)) {
                    arrayList.add("fem");
                }
                if (!this.maleNames.contains(string)) continue;
                arrayList.add("mas");
            }
        }
        for (String string : context.getSynsets()) {
            arrayList.add("ss=" + string);
        }
        return arrayList;
    }

    private void addEvent(String string, Context context) {
        List<String> list = this.getFeatures(context);
        this.events.add(new Event(string, list.toArray(new String[list.size()])));
    }

    private GenderEnum getGender(Context context) {
        if (ResolverUtils.malePronounPattern.matcher(context.getHeadTokenText()).matches()) {
            return GenderEnum.MALE;
        }
        if (ResolverUtils.femalePronounPattern.matcher(context.getHeadTokenText()).matches()) {
            return GenderEnum.FEMALE;
        }
        if (ResolverUtils.neuterPronounPattern.matcher(context.getHeadTokenText()).matches()) {
            return GenderEnum.NEUTER;
        }
        Object[] objectArray = context.getTokens();
        int n = objectArray.length - 1;
        for (int i = 0; i < n; ++i) {
            String string = objectArray[i].toString();
            if (string.equals("Mr.") || string.equals("Mr")) {
                return GenderEnum.MALE;
            }
            if (!string.equals("Mrs.") && !string.equals("Mrs") && !string.equals("Ms.") && !string.equals("Ms")) continue;
            return GenderEnum.FEMALE;
        }
        return GenderEnum.UNKNOWN;
    }

    private GenderEnum getGender(List<Context> list) {
        for (Context context : list) {
            GenderEnum genderEnum = this.getGender(context);
            if (genderEnum == GenderEnum.UNKNOWN) continue;
            return genderEnum;
        }
        return GenderEnum.UNKNOWN;
    }

    @Override
    public void setExtents(Context[] contextArray) {
        Object object;
        HashList<Integer> hashList = new HashList<Integer>();
        ArrayList<Context> arrayList = new ArrayList<Context>();
        for (Context object22 : contextArray) {
            if (object22.getId() != -1) {
                hashList.addToList(object22.getId(), object22);
                continue;
            }
            arrayList.add(object22);
        }
        ArrayList<Context> arrayList2 = new ArrayList<Context>();
        ArrayList<Context> arrayList3 = new ArrayList<Context>();
        ArrayList<Context> arrayList4 = new ArrayList<Context>();
        for (Integer n : hashList.keySet()) {
            object = (List)hashList.get(n);
            GenderEnum genderEnum = this.getGender((List<Context>)object);
            if (genderEnum == null) continue;
            if (genderEnum == GenderEnum.MALE) {
                arrayList2.addAll((Collection<Context>)object);
                continue;
            }
            if (genderEnum == GenderEnum.FEMALE) {
                arrayList3.addAll((Collection<Context>)object);
                continue;
            }
            if (genderEnum != GenderEnum.NEUTER) continue;
            arrayList4.addAll((Collection<Context>)object);
        }
        for (Context context : arrayList) {
            object = this.getGender(context);
            if (object == GenderEnum.MALE) {
                arrayList2.add(context);
                continue;
            }
            if (object == GenderEnum.FEMALE) {
                arrayList3.add(context);
                continue;
            }
            if (object != GenderEnum.NEUTER) continue;
            arrayList4.add(context);
        }
        for (Context context : arrayList2) {
            this.addEvent(GenderEnum.MALE.toString(), context);
        }
        for (Context context : arrayList3) {
            this.addEvent(GenderEnum.FEMALE.toString(), context);
        }
        for (Context context : arrayList4) {
            this.addEvent(GenderEnum.NEUTER.toString(), context);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: GenderModel modelName < tiger/NN bear/NN");
            System.exit(1);
        }
        String string = stringArray[0];
        GenderModel genderModel = new GenderModel(string, false);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            String[] stringArray2 = string2.split(" ");
            double[] dArray = genderModel.genderDistribution(Context.parseContext(stringArray2[0]));
            System.out.println("m=" + dArray[genderModel.getMaleIndex()] + " f=" + dArray[genderModel.getFemaleIndex()] + " n=" + dArray[genderModel.getNeuterIndex()] + " " + genderModel.getFeatures(Context.parseContext(stringArray2[0])));
            string2 = bufferedReader.readLine();
        }
    }

    @Override
    public double[] genderDistribution(Context context) {
        List<String> list = this.getFeatures(context);
        if (this.debugOn) {
            // empty if block
        }
        return this.testModel.eval(list.toArray(new String[list.size()]));
    }

    @Override
    public void trainModel() throws IOException {
        if (this.debugOn) {
            FileWriter fileWriter = new FileWriter(this.modelName + ".events");
            for (Event event : this.events) {
                fileWriter.write(event.toString() + "\n");
            }
            fileWriter.close();
        }
        new SuffixSensitiveGISModelWriter((AbstractModel)GIS.trainModel((EventStream)new CollectionEventStream(this.events), (boolean)true), new File(this.modelName + this.modelExtension)).persist();
    }

    @Override
    public int getFemaleIndex() {
        return this.femaleIndex;
    }

    @Override
    public int getMaleIndex() {
        return this.maleIndex;
    }

    @Override
    public int getNeuterIndex() {
        return this.neuterIndex;
    }
}

