/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.sim;

import chalk.tools.coref.sim.Context;
import chalk.tools.coref.sim.Gender;
import chalk.tools.coref.sim.GenderEnum;
import chalk.tools.coref.sim.GenderModel;
import chalk.tools.coref.sim.Number;
import chalk.tools.coref.sim.NumberEnum;
import chalk.tools.coref.sim.NumberModel;
import chalk.tools.coref.sim.TestGenderModel;
import chalk.tools.coref.sim.TestNumberModel;
import java.io.IOException;

public class MaxentCompatibilityModel {
    private final double minGenderProb = 0.66;
    private final double minNumberProb = 0.66;
    private static TestGenderModel genModel;
    private static TestNumberModel numModel;
    private boolean debugOn = false;

    public MaxentCompatibilityModel(String string) throws IOException {
        genModel = GenderModel.testModel(string + "/gen");
        numModel = NumberModel.testModel(string + "/num");
    }

    public Gender computeGender(Context context) {
        double[] dArray = genModel.genderDistribution(context);
        if (this.debugOn) {
            System.err.println("MaxentCompatibilityModel.computeGender: " + context.toString() + " m=" + dArray[genModel.getMaleIndex()] + " f=" + dArray[genModel.getFemaleIndex()] + " n=" + dArray[genModel.getNeuterIndex()]);
        }
        Gender gender = genModel.getMaleIndex() >= 0 && dArray[genModel.getMaleIndex()] > 0.66 ? new Gender(GenderEnum.MALE, dArray[genModel.getMaleIndex()]) : (genModel.getFemaleIndex() >= 0 && dArray[genModel.getFemaleIndex()] > 0.66 ? new Gender(GenderEnum.FEMALE, dArray[genModel.getFemaleIndex()]) : (genModel.getNeuterIndex() >= 0 && dArray[genModel.getNeuterIndex()] > 0.66 ? new Gender(GenderEnum.NEUTER, dArray[genModel.getNeuterIndex()]) : new Gender(GenderEnum.UNKNOWN, 0.66)));
        return gender;
    }

    public Number computeNumber(Context context) {
        double[] dArray = numModel.numberDist(context);
        Number number = dArray[numModel.getSingularIndex()] > 0.66 ? new Number(NumberEnum.SINGULAR, dArray[numModel.getSingularIndex()]) : (dArray[numModel.getPluralIndex()] > 0.66 ? new Number(NumberEnum.PLURAL, dArray[numModel.getPluralIndex()]) : new Number(NumberEnum.UNKNOWN, 0.66));
        return number;
    }
}

