/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.sim;

import chalk.tools.coref.resolver.ResolverUtils;
import chalk.tools.coref.sim.Context;
import chalk.tools.coref.sim.NumberEnum;
import chalk.tools.coref.sim.TestNumberModel;
import chalk.tools.coref.sim.TrainSimilarityModel;
import chalk.tools.util.CollectionEventStream;
import chalk.tools.util.HashList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nak.io.SuffixSensitiveGISModelReader;
import nak.io.SuffixSensitiveGISModelWriter;
import nak.maxent.GIS;
import nak.model.AbstractModel;
import nak.model.Event;
import nak.model.EventStream;
import nak.model.MaxentModel;

public class NumberModel
implements TestNumberModel,
TrainSimilarityModel {
    private String modelName;
    private String modelExtension = ".bin.gz";
    private MaxentModel testModel;
    private List<Event> events;
    private int singularIndex;
    private int pluralIndex;

    public static TestNumberModel testModel(String string) throws IOException {
        NumberModel numberModel = new NumberModel(string, false);
        return numberModel;
    }

    public static TrainSimilarityModel trainModel(String string) throws IOException {
        NumberModel numberModel = new NumberModel(string, true);
        return numberModel;
    }

    private NumberModel(String string, boolean bl) throws IOException {
        this.modelName = string;
        if (bl) {
            this.events = new ArrayList<Event>();
        } else {
            this.testModel = new SuffixSensitiveGISModelReader(new File(string + this.modelExtension)).getModel();
            this.singularIndex = this.testModel.getIndex(NumberEnum.SINGULAR.toString());
            this.pluralIndex = this.testModel.getIndex(NumberEnum.PLURAL.toString());
        }
    }

    private List<String> getFeatures(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("default");
        Object[] objectArray = context.getTokens();
        int n = objectArray.length - 1;
        for (int i = 0; i < n; ++i) {
            arrayList.add("mw=" + objectArray[i].toString());
        }
        arrayList.add("hw=" + context.getHeadTokenText().toLowerCase());
        arrayList.add("ht=" + context.getHeadTokenTag());
        return arrayList;
    }

    private void addEvent(String string, Context context) {
        List<String> list = this.getFeatures(context);
        this.events.add(new Event(string, list.toArray(new String[list.size()])));
    }

    public NumberEnum getNumber(Context context) {
        if (ResolverUtils.singularPronounPattern.matcher(context.getHeadTokenText()).matches()) {
            return NumberEnum.SINGULAR;
        }
        if (ResolverUtils.pluralPronounPattern.matcher(context.getHeadTokenText()).matches()) {
            return NumberEnum.PLURAL;
        }
        return NumberEnum.UNKNOWN;
    }

    private NumberEnum getNumber(List<Context> list) {
        for (Context context : list) {
            NumberEnum numberEnum = this.getNumber(context);
            if (numberEnum == NumberEnum.UNKNOWN) continue;
            return numberEnum;
        }
        return NumberEnum.UNKNOWN;
    }

    @Override
    public void setExtents(Context[] contextArray) {
        Object object;
        HashList<Integer> hashList = new HashList<Integer>();
        ArrayList<Context> arrayList = new ArrayList<Context>();
        for (Context context : contextArray) {
            if (context.getId() != -1) {
                hashList.addToList(context.getId(), context);
                continue;
            }
            arrayList.add(context);
        }
        ArrayList<Context> arrayList2 = new ArrayList<Context>();
        ArrayList<Context> arrayList3 = new ArrayList<Context>();
        for (Integer comparable : hashList.keySet()) {
            object = (List)hashList.get(comparable);
            NumberEnum numberEnum = this.getNumber((List<Context>)object);
            if (numberEnum == NumberEnum.SINGULAR) {
                arrayList2.addAll((Collection<Context>)object);
                continue;
            }
            if (numberEnum != NumberEnum.PLURAL) continue;
            arrayList3.addAll((Collection<Context>)object);
        }
        for (Context context : arrayList) {
            object = this.getNumber(context);
            if (object == NumberEnum.SINGULAR) {
                arrayList2.add(context);
                continue;
            }
            if (object != NumberEnum.PLURAL) continue;
            arrayList3.add(context);
        }
        for (Context context : arrayList2) {
            this.addEvent(NumberEnum.SINGULAR.toString(), context);
        }
        for (Context context : arrayList3) {
            this.addEvent(NumberEnum.PLURAL.toString(), context);
        }
    }

    @Override
    public double[] numberDist(Context context) {
        List<String> list = this.getFeatures(context);
        return this.testModel.eval(list.toArray(new String[list.size()]));
    }

    @Override
    public int getSingularIndex() {
        return this.singularIndex;
    }

    @Override
    public int getPluralIndex() {
        return this.pluralIndex;
    }

    @Override
    public void trainModel() throws IOException {
        new SuffixSensitiveGISModelWriter((AbstractModel)GIS.trainModel((EventStream)new CollectionEventStream(this.events), (int)100, (int)10), new File(this.modelName + this.modelExtension)).persist();
    }
}

