/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.sim;

import chalk.tools.coref.resolver.ResolverUtils;
import chalk.tools.coref.sim.Context;
import chalk.tools.coref.sim.TestSimilarityModel;
import chalk.tools.coref.sim.TrainSimilarityModel;
import chalk.tools.util.CollectionEventStream;
import chalk.tools.util.HashList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nak.io.SuffixSensitiveGISModelReader;
import nak.io.SuffixSensitiveGISModelWriter;
import nak.maxent.GIS;
import nak.model.AbstractModel;
import nak.model.Event;
import nak.model.EventStream;
import nak.model.MaxentModel;

public class SimilarityModel
implements TestSimilarityModel,
TrainSimilarityModel {
    private String modelName;
    private String modelExtension = ".bin.gz";
    private MaxentModel testModel;
    private List<Event> events;
    private int SAME_INDEX;
    private static final String SAME = "same";
    private static final String DIFF = "diff";
    private boolean debugOn = false;

    public static TestSimilarityModel testModel(String string) throws IOException {
        return new SimilarityModel(string, false);
    }

    public static TrainSimilarityModel trainModel(String string) throws IOException {
        SimilarityModel similarityModel = new SimilarityModel(string, true);
        return similarityModel;
    }

    private SimilarityModel(String string, boolean bl) throws IOException {
        this.modelName = string;
        if (bl) {
            this.events = new ArrayList<Event>();
        } else {
            this.testModel = new SuffixSensitiveGISModelReader(new File(string + this.modelExtension)).getModel();
            this.SAME_INDEX = this.testModel.getIndex(SAME);
        }
    }

    private void addEvent(boolean bl, Context context, Context context2) {
        if (bl) {
            List<String> list = this.getFeatures(context, context2);
            this.events.add(new Event(SAME, list.toArray(new String[list.size()])));
        } else {
            List<String> list = this.getFeatures(context, context2);
            this.events.add(new Event(DIFF, list.toArray(new String[list.size()])));
        }
    }

    private Set<String> constructHeadSet(List<Context> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Context context : list) {
            hashSet.add(context.getHeadTokenText().toLowerCase());
        }
        return hashSet;
    }

    private boolean hasSameHead(Set<String> set, Set<String> set2) {
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!set2.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean hasSameNameType(Set<String> set, Set<String> set2) {
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!set2.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean hasSuperClass(List<Context> list, List<Context> list2) {
        for (Context context : list) {
            Iterator<Context> iterator = list2.iterator();
            while (iterator.hasNext()) {
                if (!this.inSuperClass(context, iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    private Set<Context> constructExclusionSet(Integer n, HashList hashList, Map<Integer, Set<String>> map, Map<Integer, Set<String>> map2, List<Context> list) {
        HashSet<Context> hashSet = new HashSet<Context>();
        Set<String> set = map.get(n);
        Set<String> set2 = map2.get(n);
        List list2 = (List)hashList.get(n);
        for (Object object : hashList.keySet()) {
            List object2 = (List)hashList.get(object);
            if (((Integer)object).equals(n)) {
                hashSet.addAll(object2);
                continue;
            }
            if (map2.get(object).isEmpty()) {
                hashSet.addAll(object2);
                continue;
            }
            if (this.hasSameHead(set, map.get(object))) {
                hashSet.addAll(object2);
                continue;
            }
            if (this.hasSameNameType(set2, map2.get(object))) {
                hashSet.addAll(object2);
                continue;
            }
            if (!this.hasSuperClass(list2, object2)) continue;
            hashSet.addAll(object2);
        }
        ArrayList arrayList = new ArrayList(1);
        for (Context context : list) {
            arrayList.clear();
            arrayList.add(context);
            if (set.contains(context.getHeadTokenText().toLowerCase())) {
                hashSet.add(context);
                continue;
            }
            if (context.getNameType() == null) {
                hashSet.add(context);
                continue;
            }
            if (set2.contains(context.getNameType())) {
                hashSet.add(context);
                continue;
            }
            if (!this.hasSuperClass(list2, arrayList)) continue;
            hashSet.add(context);
        }
        return hashSet;
    }

    private Map<Integer, Set<String>> constructHeadSets(HashList hashList) {
        HashMap<Integer, Set<String>> hashMap = new HashMap<Integer, Set<String>>();
        for (Integer n : hashList.keySet()) {
            List list = (List)hashList.get(n);
            hashMap.put(n, this.constructHeadSet(list));
        }
        return hashMap;
    }

    private Set<String> constructNameSet(List<Context> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Context context : list) {
            if (context.getNameType() == null) continue;
            hashSet.add(context.getNameType());
        }
        return hashSet;
    }

    private Map<Integer, Set<String>> constructNameSets(HashList hashList) {
        HashMap<Integer, Set<String>> hashMap = new HashMap<Integer, Set<String>>();
        for (Integer n : hashList.keySet()) {
            List list = (List)hashList.get(n);
            hashMap.put(n, this.constructNameSet(list));
        }
        return hashMap;
    }

    private boolean inSuperClass(Context context, Context context2) {
        if (context.getSynsets().size() == 0 || context2.getSynsets().size() == 0) {
            return false;
        }
        int n = 0;
        for (String string : context.getSynsets()) {
            if (!context2.getSynsets().contains(string)) continue;
            ++n;
        }
        if (n == 0) {
            return false;
        }
        return n == context.getSynsets().size() || n == context2.getSynsets().size();
    }

    @Override
    public void setExtents(Context[] contextArray) {
        HashList<Integer> hashList = new HashList<Integer>();
        ArrayList<Context> arrayList = new ArrayList<Context>();
        ArrayList<Context> arrayList2 = new ArrayList<Context>();
        for (Context object2 : contextArray) {
            if (object2.getId() == -1) {
                arrayList.add(object2);
            } else {
                hashList.addToList(object2.getId(), object2);
            }
            arrayList2.add(object2);
        }
        int n = 0;
        Map<Integer, Set<String>> map = this.constructHeadSets(hashList);
        Map<Integer, Set<String>> map2 = this.constructNameSets(hashList);
        for (Integer n2 : hashList.keySet()) {
            Set<String> set = map2.get(n2);
            if (set.isEmpty()) continue;
            List list = (List)hashList.get(n2);
            Set<Context> set2 = this.constructExclusionSet(n2, hashList, map, map2, arrayList);
            if (list.size() == 1) {
                // empty if block
            }
            int n3 = list.size();
            for (int i = 0; i < n3; ++i) {
                Context context = (Context)list.get(i);
                block3: for (int j = i + 1; j < n3; ++j) {
                    Context context2 = (Context)list.get(j);
                    this.addEvent(true, context, context2);
                    int n4 = n;
                    do {
                        Context context3 = (Context)arrayList2.get(n);
                        n = (n + 1) % arrayList2.size();
                        if (set2.contains(context3)) continue;
                        if (this.debugOn) {
                            System.err.println(context.toString() + " " + set + " " + context3.toString() + " " + map2.get(context3.getId()));
                        }
                        this.addEvent(false, context, context3);
                        continue block3;
                    } while (n != n4);
                }
            }
        }
    }

    @Override
    public double compatible(Context context, Context context2) {
        List<String> list = this.getFeatures(context, context2);
        if (this.debugOn) {
            System.err.println("SimilarityModel.compatible: feats=" + list);
        }
        return this.testModel.eval(list.toArray(new String[list.size()]))[this.SAME_INDEX];
    }

    @Override
    public void trainModel() throws IOException {
        if (this.debugOn) {
            FileWriter fileWriter = new FileWriter(this.modelName + ".events");
            for (Event event : this.events) {
                fileWriter.write(event.toString() + "\n");
            }
            fileWriter.close();
        }
        new SuffixSensitiveGISModelWriter((AbstractModel)GIS.trainModel((EventStream)new CollectionEventStream(this.events), (int)100, (int)10), new File(this.modelName + this.modelExtension)).persist();
    }

    private boolean isName(Context context) {
        return context.getHeadTokenTag().startsWith("NNP");
    }

    private boolean isCommonNoun(Context context) {
        return !context.getHeadTokenTag().startsWith("NNP") && context.getHeadTokenTag().startsWith("NN");
    }

    private boolean isPronoun(Context context) {
        return context.getHeadTokenTag().startsWith("PRP");
    }

    private boolean isNumber(Context context) {
        return context.getHeadTokenTag().equals("CD");
    }

    private List<String> getNameCommonFeatures(Context context, Context context2) {
        Set<String> set = context2.getSynsets();
        ArrayList<String> arrayList = new ArrayList<String>(2 + set.size());
        arrayList.add("nn=" + context.getNameType() + "," + context2.getNameType());
        arrayList.add("nw=" + context.getNameType() + "," + context2.getHeadTokenText().toLowerCase());
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            arrayList.add("ns=" + context.getNameType() + "," + iterator.next());
        }
        if (context.getNameType() == null) {
            // empty if block
        }
        return arrayList;
    }

    private List<String> getNameNumberFeatures(Context context, Context context2) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("nt=" + context.getNameType() + "," + context2.getHeadTokenTag());
        arrayList.add("nn=" + context.getNameType() + "," + context2.getNameType());
        return arrayList;
    }

    private List<String> getNamePronounFeatures(Context context, Context context2) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("nw=" + context.getNameType() + "," + context2.getHeadTokenText().toLowerCase());
        arrayList.add("ng=" + context.getNameType() + "," + ResolverUtils.getPronounGender(context2.getHeadTokenText().toLowerCase()));
        return arrayList;
    }

    private List<String> getCommonPronounFeatures(Context context, Context context2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = context.getSynsets();
        String string = context2.getHeadTokenText().toLowerCase();
        String string2 = ResolverUtils.getPronounGender(string);
        arrayList.add("wn=" + string + "," + context.getNameType());
        for (String string3 : set) {
            arrayList.add("ws=" + string + "," + string3);
            arrayList.add("gs=" + string2 + "," + string3);
        }
        return arrayList;
    }

    private List<String> getCommonNumberFeatures(Context context, Context context2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = context.getSynsets();
        for (String string : set) {
            arrayList.add("ts=" + context2.getHeadTokenTag() + "," + string);
            arrayList.add("ns=" + context2.getNameType() + "," + string);
        }
        arrayList.add("nn=" + context2.getNameType() + "," + context.getNameType());
        return arrayList;
    }

    private List<String> getNumberPronounFeatures(Context context, Context context2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = context2.getHeadTokenText().toLowerCase();
        String string2 = ResolverUtils.getPronounGender(string);
        arrayList.add("wt=" + string + "," + context.getHeadTokenTag());
        arrayList.add("wn=" + string + "," + context.getNameType());
        arrayList.add("wt=" + string2 + "," + context.getHeadTokenTag());
        arrayList.add("wn=" + string2 + "," + context.getNameType());
        return arrayList;
    }

    private List<String> getNameNameFeatures(Context context, Context context2) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        if (context.getNameType() == null && context2.getNameType() == null) {
            arrayList.add("nn=" + context.getNameType() + "," + context2.getNameType());
        } else if (context.getNameType() == null) {
            arrayList.add("nn=" + context.getNameType() + "," + context2.getNameType());
        } else if (context2.getNameType() == null) {
            arrayList.add("nn=" + context2.getNameType() + "," + context.getNameType());
        } else {
            if (context.getNameType().compareTo(context2.getNameType()) < 0) {
                arrayList.add("nn=" + context.getNameType() + "," + context2.getNameType());
            } else {
                arrayList.add("nn=" + context2.getNameType() + "," + context.getNameType());
            }
            if (context.getNameType().equals(context2.getNameType())) {
                arrayList.add("sameNameType");
            }
        }
        return arrayList;
    }

    private List<String> getCommonCommonFeatures(Context context, Context context2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = context.getSynsets();
        Set<String> set2 = context2.getSynsets();
        if (set.size() == 0) {
            return arrayList;
        }
        if (set2.size() == 0) {
            return arrayList;
        }
        int n = 0;
        for (String string : set) {
            if (!set2.contains(string)) continue;
            arrayList.add("ss=" + string);
            ++n;
        }
        if (n == 0) {
            arrayList.add("ncss");
        } else if (n == set.size() && n == set2.size()) {
            arrayList.add("samess");
        } else if (n == set.size()) {
            arrayList.add("2isa1");
        } else if (n == set2.size()) {
            arrayList.add("1isa2");
        }
        return arrayList;
    }

    private List<String> getPronounPronounFeatures(Context context, Context context2) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = ResolverUtils.getPronounGender(context.getHeadTokenText());
        if (string2.equals(string = ResolverUtils.getPronounGender(context2.getHeadTokenText()))) {
            arrayList.add("sameGender");
        } else {
            arrayList.add("diffGender");
        }
        return arrayList;
    }

    private List<String> getFeatures(Context context, Context context2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("default");
        String string = context.getHeadTokenText().toLowerCase();
        String string2 = context2.getHeadTokenText().toLowerCase();
        if (string.compareTo(string2) < 0) {
            arrayList.add("ww=" + string + "," + string2);
        } else {
            arrayList.add("ww=" + string2 + "," + string);
        }
        if (string.equals(string2)) {
            arrayList.add("sameHead");
        }
        if (this.isName(context)) {
            if (this.isName(context2)) {
                arrayList.addAll(this.getNameNameFeatures(context, context2));
            } else if (this.isCommonNoun(context2)) {
                arrayList.addAll(this.getNameCommonFeatures(context, context2));
            } else if (this.isPronoun(context2)) {
                arrayList.addAll(this.getNamePronounFeatures(context, context2));
            } else if (this.isNumber(context2)) {
                arrayList.addAll(this.getNameNumberFeatures(context, context2));
            }
        } else if (this.isCommonNoun(context)) {
            if (this.isName(context2)) {
                arrayList.addAll(this.getNameCommonFeatures(context2, context));
            } else if (this.isCommonNoun(context2)) {
                arrayList.addAll(this.getCommonCommonFeatures(context, context2));
            } else if (this.isPronoun(context2)) {
                arrayList.addAll(this.getCommonPronounFeatures(context, context2));
            } else if (this.isNumber(context2)) {
                arrayList.addAll(this.getCommonNumberFeatures(context, context2));
            }
        } else if (this.isPronoun(context)) {
            if (this.isName(context2)) {
                arrayList.addAll(this.getNamePronounFeatures(context2, context));
            } else if (this.isCommonNoun(context2)) {
                arrayList.addAll(this.getCommonPronounFeatures(context2, context));
            } else if (this.isPronoun(context2)) {
                arrayList.addAll(this.getPronounPronounFeatures(context, context2));
            } else if (this.isNumber(context2)) {
                arrayList.addAll(this.getNumberPronounFeatures(context2, context));
            }
        } else if (this.isNumber(context)) {
            if (this.isName(context2)) {
                arrayList.addAll(this.getNameNumberFeatures(context2, context));
            } else if (this.isCommonNoun(context2)) {
                arrayList.addAll(this.getCommonNumberFeatures(context2, context));
            } else if (this.isPronoun(context2)) {
                arrayList.addAll(this.getNumberPronounFeatures(context, context2));
            } else if (this.isNumber(context2)) {
                // empty if block
            }
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: SimilarityModel modelName < tiger/NN bear/NN");
            System.exit(1);
        }
        String string = stringArray[0];
        SimilarityModel similarityModel = new SimilarityModel(string, false);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            String[] stringArray2 = string2.split(" ");
            double d = similarityModel.compatible(Context.parseContext(stringArray2[0]), Context.parseContext(stringArray2[1]));
            System.out.println(d + " " + similarityModel.getFeatures(Context.parseContext(stringArray2[0]), Context.parseContext(stringArray2[1])));
            string2 = bufferedReader.readLine();
        }
    }
}

