/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.doccat;

import chalk.tools.doccat.DocumentCategorizer;
import chalk.tools.doccat.DocumentSample;
import chalk.tools.util.eval.Mean;
import java.util.Iterator;

public class DocumentCategorizerEvaluator {
    private DocumentCategorizer categorizer;
    private Mean accuracy = new Mean();

    public DocumentCategorizerEvaluator(DocumentCategorizer documentCategorizer) {
        this.categorizer = documentCategorizer;
    }

    public void evaluteSample(DocumentSample documentSample) {
        String[] stringArray = documentSample.getText();
        double[] dArray = this.categorizer.categorize(stringArray);
        String string = this.categorizer.getBestCategory(dArray);
        if (documentSample.getCategory().equals(string)) {
            this.accuracy.add(1.0);
        } else {
            this.accuracy.add(0.0);
        }
    }

    public void evaluate(Iterator<DocumentSample> iterator) {
        while (iterator.hasNext()) {
            this.evaluteSample(iterator.next());
        }
    }

    public double getAccuracy() {
        return this.accuracy.mean();
    }

    public String toString() {
        return "Accuracy: " + this.accuracy.mean() + "\n" + "Number of documents: " + this.accuracy.count();
    }
}

