/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats;

import chalk.tools.namefind.NameSample;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import chalk.tools.util.Span;
import chalk.tools.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class BioNLP2004NameSampleStream
implements ObjectStream<NameSample> {
    public static final int GENERATE_DNA_ENTITIES = 1;
    public static final int GENERATE_PROTEIN_ENTITIES = 2;
    public static final int GENERATE_CELLTYPE_ENTITIES = 4;
    public static final int GENERATE_CELLLINE_ENTITIES = 8;
    public static final int GENERATE_RNA_ENTITIES = 16;
    private final int types;
    private final ObjectStream<String> lineStream;

    public BioNLP2004NameSampleStream(InputStream inputStream, int n) {
        try {
            this.lineStream = new PlainTextByLineStream(inputStream, "UTF-8");
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        this.types = n;
    }

    @Override
    public NameSample read() throws IOException {
        String[] stringArray;
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        while ((string = this.lineStream.read()) != null && !StringUtil.isEmpty(string.trim())) {
            if (string.startsWith("###MEDLINE:")) {
                bl = true;
                this.lineStream.read();
                continue;
            }
            if (string.contains("ABSTRACT TRUNCATED")) continue;
            stringArray = string.split("\t");
            if (stringArray.length == 2) {
                arrayList.add(stringArray[0]);
                arrayList2.add(stringArray[1]);
                continue;
            }
            throw new IOException("Expected two fields per line in training data, got " + stringArray.length + " for line '" + string + "'!");
        }
        if (arrayList.size() > 0) {
            stringArray = new ArrayList();
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string2 = (String)arrayList2.get(i);
                if (string2.endsWith("DNA") && (this.types & 1) == 0) {
                    string2 = "O";
                }
                if (string2.endsWith("protein") && (this.types & 2) == 0) {
                    string2 = "O";
                }
                if (string2.endsWith("cell_type") && (this.types & 4) == 0) {
                    string2 = "O";
                }
                if (string2.endsWith("cell_line") && (this.types & 4) == 0) {
                    string2 = "O";
                }
                if (string2.endsWith("RNA") && (this.types & 0x10) == 0) {
                    string2 = "O";
                }
                if (string2.startsWith("B-")) {
                    if (n != -1) {
                        stringArray.add(new Span(n, n2, ((String)arrayList2.get(n)).substring(2)));
                        n = -1;
                        n2 = -1;
                    }
                    n = i;
                    n2 = i + 1;
                    continue;
                }
                if (string2.startsWith("I-")) {
                    ++n2;
                    continue;
                }
                if (string2.equals("O")) {
                    if (n == -1) continue;
                    stringArray.add(new Span(n, n2, ((String)arrayList2.get(n)).substring(2)));
                    n = -1;
                    n2 = -1;
                    continue;
                }
                throw new IOException("Invalid tag: " + string2);
            }
            if (n != -1) {
                stringArray.add(new Span(n, n2, ((String)arrayList2.get(n)).substring(2)));
            }
            return new NameSample(arrayList.toArray(new String[arrayList.size()]), stringArray.toArray(new Span[stringArray.size()]), bl);
        }
        if (string != null) {
            return this.read();
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.lineStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.lineStream.close();
    }
}

