/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats;

import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.cmdline.params.LanguageFormatParams;
import chalk.tools.formats.BioNLP2004NameSampleStream;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.namefind.NameSample;
import chalk.tools.util.ObjectStream;

public class BioNLP2004NameSampleStreamFactory
extends LanguageSampleStreamFactory<NameSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "bionlp2004", new BioNLP2004NameSampleStreamFactory(Parameters.class));
    }

    protected <P> BioNLP2004NameSampleStreamFactory(Class<P> clazz) {
        super(clazz);
    }

    @Override
    public ObjectStream<NameSample> create(String[] stringArray) {
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        this.language = parameters.getLang();
        int n = 0;
        if (parameters.getTypes().contains("DNA")) {
            n |= 1;
        } else if (parameters.getTypes().contains("protein")) {
            n |= 2;
        } else if (parameters.getTypes().contains("cell_type")) {
            n |= 4;
        } else if (parameters.getTypes().contains("cell_line")) {
            n |= 8;
        } else if (parameters.getTypes().contains("RNA")) {
            n |= 0x10;
        }
        return new BioNLP2004NameSampleStream(CmdLineUtil.openInFile(parameters.getData()), n);
    }

    static interface Parameters
    extends LanguageFormatParams {
        @ArgumentParser.ParameterDescription(valueName="DNA,protein,cell_type,cell_line,RNA")
        public String getTypes();
    }
}

