/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats;

import chalk.tools.formats.Conll02NameSampleStream;
import chalk.tools.namefind.NameSample;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import chalk.tools.util.Span;
import chalk.tools.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class Conll03NameSampleStream
implements ObjectStream<NameSample> {
    private final LANGUAGE lang;
    private final ObjectStream<String> lineStream;
    private final int types;

    public Conll03NameSampleStream(LANGUAGE lANGUAGE, ObjectStream<String> objectStream, int n) {
        this.lang = lANGUAGE;
        this.lineStream = objectStream;
        this.types = n;
    }

    public Conll03NameSampleStream(LANGUAGE lANGUAGE, InputStream inputStream, int n) {
        this.lang = lANGUAGE;
        try {
            this.lineStream = new PlainTextByLineStream(inputStream, "UTF-8");
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        this.types = n;
    }

    @Override
    public NameSample read() throws IOException {
        Object object;
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        boolean bl = false;
        while ((string = this.lineStream.read()) != null && !StringUtil.isEmpty(string)) {
            if (string.startsWith("-DOCSTART-")) {
                bl = true;
                object = this.lineStream.read();
                if (StringUtil.isEmpty((CharSequence)object)) continue;
                throw new IOException("Empty line after -DOCSTART- not empty: '" + (String)object + "'!");
            }
            object = string.split(" ");
            if (LANGUAGE.EN.equals((Object)this.lang) && ((String[])object).length == 4) {
                arrayList.add(object[0]);
                arrayList2.add(object[3]);
                continue;
            }
            if (!LANGUAGE.DE.equals((Object)this.lang) || ((String[])object).length != 5) continue;
            arrayList.add(object[0]);
            arrayList2.add(object[4]);
        }
        if (arrayList.size() > 0) {
            object = new ArrayList();
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string2 = (String)arrayList2.get(i);
                if (string2.endsWith("PER") && (this.types & 1) == 0) {
                    string2 = "O";
                }
                if (string2.endsWith("ORG") && (this.types & 2) == 0) {
                    string2 = "O";
                }
                if (string2.endsWith("LOC") && (this.types & 4) == 0) {
                    string2 = "O";
                }
                if (string2.endsWith("MISC") && (this.types & 8) == 0) {
                    string2 = "O";
                }
                if (string2.equals("O")) {
                    if (n == -1) continue;
                    object.add(Conll02NameSampleStream.extract(n, n2, (String)arrayList2.get(n)));
                    n = -1;
                    n2 = -1;
                    continue;
                }
                if (string2.startsWith("B-")) {
                    if (n != -1) {
                        object.add(Conll02NameSampleStream.extract(n, n2, (String)arrayList2.get(n)));
                    }
                    n = i;
                    n2 = i + 1;
                    continue;
                }
                if (string2.startsWith("I-")) {
                    if (n == -1) {
                        n = i;
                        n2 = i + 1;
                        continue;
                    }
                    if (!string2.endsWith(((String)arrayList2.get(n)).substring(1))) {
                        object.add(Conll02NameSampleStream.extract(n, n2, (String)arrayList2.get(n)));
                        n = i;
                        n2 = i + 1;
                        continue;
                    }
                    ++n2;
                    continue;
                }
                throw new IOException("Invalid tag: " + string2);
            }
            if (n != -1) {
                object.add(Conll02NameSampleStream.extract(n, n2, (String)arrayList2.get(n)));
            }
            return new NameSample(arrayList.toArray(new String[arrayList.size()]), object.toArray(new Span[object.size()]), bl);
        }
        if (string != null) {
            return this.read();
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.lineStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.lineStream.close();
    }

    public static enum LANGUAGE {
        EN,
        DE;

    }
}

