/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats;

import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.cmdline.params.LanguageFormatParams;
import chalk.tools.coref.CorefSample;
import chalk.tools.coref.CorefSampleDataStream;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.ParagraphStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.FileInputStream;

public class CorefSampleStreamFactory
extends LanguageSampleStreamFactory<CorefSample> {
    protected CorefSampleStreamFactory() {
        super(Parameters.class);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(CorefSample.class, "opennlp", new CorefSampleStreamFactory());
    }

    @Override
    public ObjectStream<CorefSample> create(String[] stringArray) {
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        this.language = parameters.getLang();
        CmdLineUtil.checkInputFile("Data", parameters.getData());
        FileInputStream fileInputStream = CmdLineUtil.openInFile(parameters.getData());
        ParagraphStream paragraphStream = new ParagraphStream(new PlainTextByLineStream(fileInputStream.getChannel(), parameters.getEncoding()));
        return new CorefSampleDataStream(paragraphStream);
    }

    static interface Parameters
    extends LanguageFormatParams {
    }
}

