/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats;

import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import chalk.tools.util.StringList;
import chalk.tools.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Locale;

public class NameFinderCensus90NameStream
implements ObjectStream<StringList> {
    private final Locale locale = new Locale("en");
    private final Charset encoding;
    private final ObjectStream<String> lineStream;

    public NameFinderCensus90NameStream(ObjectStream<String> objectStream) {
        this.encoding = Charset.defaultCharset();
        this.lineStream = objectStream;
    }

    public NameFinderCensus90NameStream(InputStream inputStream, Charset charset) {
        this.encoding = charset;
        this.lineStream = new PlainTextByLineStream(inputStream, this.encoding);
    }

    @Override
    public StringList read() throws IOException {
        int n;
        String string = this.lineStream.read();
        StringList stringList = null;
        if (string != null && !StringUtil.isEmpty(string) && (n = string.indexOf(32)) != -1) {
            String string2 = string.substring(0, n);
            String string3 = string2.length() > 2 && string2.startsWith("MC") ? string2.substring(0, 1).toUpperCase(this.locale) + string2.substring(1, 2).toLowerCase(this.locale) + string2.substring(2, 3).toUpperCase(this.locale) + string2.substring(3).toLowerCase(this.locale) : string2.substring(0, 1).toUpperCase(this.locale) + string2.substring(1).toLowerCase(this.locale);
            stringList = new StringList(new String[]{string3});
        }
        return stringList;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.lineStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.lineStream.close();
    }
}

