/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats;

import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.cmdline.params.LanguageFormatParams;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.sentdetect.SentenceSample;
import chalk.tools.sentdetect.SentenceSampleStream;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.FileInputStream;

public class SentenceSampleStreamFactory
extends LanguageSampleStreamFactory<SentenceSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentenceSample.class, "opennlp", new SentenceSampleStreamFactory(Parameters.class));
    }

    protected <P> SentenceSampleStreamFactory(Class<P> clazz) {
        super(clazz);
    }

    @Override
    public ObjectStream<SentenceSample> create(String[] stringArray) {
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        this.language = parameters.getLang();
        CmdLineUtil.checkInputFile("Data", parameters.getData());
        FileInputStream fileInputStream = CmdLineUtil.openInFile(parameters.getData());
        PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(fileInputStream.getChannel(), parameters.getEncoding());
        return new SentenceSampleStream(plainTextByLineStream);
    }

    static interface Parameters
    extends LanguageFormatParams {
    }
}

