/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats;

import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.cmdline.params.LanguageFormatParams;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.postag.POSSample;
import chalk.tools.postag.WordTagSampleStream;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.FileInputStream;

public class WordTagSampleStreamFactory
extends LanguageSampleStreamFactory<POSSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, "opennlp", new WordTagSampleStreamFactory(Parameters.class));
    }

    protected <P> WordTagSampleStreamFactory(Class<P> clazz) {
        super(clazz);
    }

    @Override
    public ObjectStream<POSSample> create(String[] stringArray) {
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        this.language = parameters.getLang();
        CmdLineUtil.checkInputFile("Data", parameters.getData());
        FileInputStream fileInputStream = CmdLineUtil.openInFile(parameters.getData());
        PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(fileInputStream.getChannel(), parameters.getEncoding());
        return new WordTagSampleStream(plainTextByLineStream);
    }

    public static interface Parameters
    extends LanguageFormatParams {
    }
}

