/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.ad;

import chalk.tools.chunker.ChunkSample;
import chalk.tools.formats.ad.ADSentenceStream;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ADChunkSampleStream
implements ObjectStream<ChunkSample> {
    protected final ObjectStream<ADSentenceStream.Sentence> adSentenceStream;
    private int start = -1;
    private int end = -1;
    private int index = 0;
    public static final String OTHER = "O";

    public ADChunkSampleStream(ObjectStream<String> objectStream) {
        this.adSentenceStream = new ADSentenceStream(objectStream);
    }

    public ADChunkSampleStream(InputStream inputStream, String string) {
        try {
            this.adSentenceStream = new ADSentenceStream(new PlainTextByLineStream(inputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    @Override
    public ChunkSample read() throws IOException {
        ADSentenceStream.Sentence sentence;
        while ((sentence = this.adSentenceStream.read()) != null) {
            if (this.end > -1 && this.index >= this.end) {
                return null;
            }
            if (this.start > -1 && this.index < this.start) {
                ++this.index;
                continue;
            }
            ADSentenceStream.SentenceParser.Node node = sentence.getRoot();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            this.processRoot(node, arrayList, arrayList2, arrayList3);
            if (arrayList.size() <= 0) continue;
            ++this.index;
            return new ChunkSample(arrayList, arrayList2, arrayList3);
        }
        return null;
    }

    protected void processRoot(ADSentenceStream.SentenceParser.Node node, List<String> list, List<String> list2, List<String> list3) {
        if (node != null) {
            ADSentenceStream.SentenceParser.TreeElement[] treeElementArray = node.getElements();
            for (int i = 0; i < treeElementArray.length; ++i) {
                if (treeElementArray[i].isLeaf()) {
                    this.processLeaf((ADSentenceStream.SentenceParser.Leaf)treeElementArray[i], false, OTHER, list, list2, list3);
                    continue;
                }
                this.processNode((ADSentenceStream.SentenceParser.Node)treeElementArray[i], list, list2, list3, null);
            }
        }
    }

    private void processNode(ADSentenceStream.SentenceParser.Node node, List<String> list, List<String> list2, List<String> list3, String string) {
        String string2 = this.getChunkTag(node);
        boolean bl = false;
        if (string2.equals(OTHER) && string != null) {
            string2 = string;
            bl = true;
        }
        ADSentenceStream.SentenceParser.TreeElement[] treeElementArray = node.getElements();
        block0: for (int i = 0; i < treeElementArray.length; ++i) {
            int n;
            if (treeElementArray[i].isLeaf()) {
                n = 0;
                String string3 = string2;
                ADSentenceStream.SentenceParser.Leaf leaf = (ADSentenceStream.SentenceParser.Leaf)treeElementArray[i];
                String string4 = this.getChunkTag(leaf);
                if (string4 != null && !string3.equals(string4)) {
                    string3 = string4;
                }
                if (this.isIntermediate(list2, list3, string3) && (bl || i > 0)) {
                    n = 1;
                }
                if (!(this.isIncludePunctuations() || leaf.getFunctionalTag() != null || i + 1 < treeElementArray.length && treeElementArray[i + 1].isLeaf() && i > 0 && treeElementArray[i - 1].isLeaf())) {
                    n = 0;
                    string3 = OTHER;
                }
                this.processLeaf(leaf, n != 0, string3, list, list2, list3);
                continue;
            }
            n = list3.size();
            this.processNode((ADSentenceStream.SentenceParser.Node)treeElementArray[i], list, list2, list3, string2);
            for (int j = list3.size() - 1; j >= n; --j) {
                if (list3.get(j).endsWith("-" + string2)) continue;
                string2 = OTHER;
                continue block0;
            }
        }
    }

    protected void processLeaf(ADSentenceStream.SentenceParser.Leaf leaf, boolean bl, String string, List<String> list, List<String> list2, List<String> list3) {
        if (leaf.getFunctionalTag() != null && string.equals(OTHER)) {
            string = this.getPhraseTagFromPosTag(leaf.getFunctionalTag());
        }
        String string2 = !string.equals(OTHER) ? (bl ? "I-" + string : "B-" + string) : string;
        list.add(leaf.getLexeme());
        if (leaf.getSyntacticTag() == null) {
            list2.add(leaf.getLexeme());
        } else {
            list2.add(ADChunkSampleStream.convertFuncTag(leaf.getFunctionalTag(), false));
        }
        list3.add(string2);
    }

    protected String getPhraseTagFromPosTag(String string) {
        if (string.equals("v-fin")) {
            return "VP";
        }
        if (string.equals("n")) {
            return "NP";
        }
        return OTHER;
    }

    public static String convertFuncTag(String string, boolean bl) {
        if (bl && ("art".equals(string) || "pron-det".equals(string) || "pron-indef".equals(string))) {
            string = "det";
        }
        return string;
    }

    protected String getChunkTag(ADSentenceStream.SentenceParser.Leaf leaf) {
        String string = leaf.getSyntacticTag();
        if ("P".equals(string)) {
            return "VP";
        }
        return null;
    }

    protected String getChunkTag(ADSentenceStream.SentenceParser.Node node) {
        String string = node.getSyntacticTag();
        String string2 = string.substring(string.lastIndexOf(":") + 1);
        while (string2.endsWith("-")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        string2 = string2.equals("np") || string2.equals("vp") || string2.equals("pp") || string2.equals("ap") || string2.equals("advp") || string2.equals("adjp") ? string2.toUpperCase() : OTHER;
        return string2;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.adSentenceStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.adSentenceStream.close();
    }

    protected boolean isIncludePunctuations() {
        return false;
    }

    protected boolean isIntermediate(List<String> list, List<String> list2, String string) {
        return list2.size() > 0 && list2.get(list2.size() - 1).endsWith("-" + string);
    }
}

