/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.ad;

import chalk.tools.chunker.ChunkSample;
import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.formats.ad.ADChunkSampleStream;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;

public class ADChunkSampleStreamFactory
extends LanguageSampleStreamFactory<ChunkSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(ChunkSample.class, "ad", new ADChunkSampleStreamFactory(Parameters.class));
    }

    protected <P> ADChunkSampleStreamFactory(Class<P> clazz) {
        super(clazz);
    }

    @Override
    public ObjectStream<ChunkSample> create(String[] stringArray) {
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        this.language = parameters.getLang();
        FileInputStream fileInputStream = CmdLineUtil.openInFile(parameters.getData());
        PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(fileInputStream.getChannel(), parameters.getEncoding());
        ADChunkSampleStream aDChunkSampleStream = new ADChunkSampleStream(plainTextByLineStream);
        if (parameters.getStart() != null && parameters.getStart() > -1) {
            aDChunkSampleStream.setStart(parameters.getStart());
        }
        if (parameters.getEnd() != null && parameters.getEnd() > -1) {
            aDChunkSampleStream.setEnd(parameters.getEnd());
        }
        return aDChunkSampleStream;
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData", description="data to be used, usually a file name.")
        public File getData();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="start", description="index of first sentence")
        @ArgumentParser.OptionalParameter
        public Integer getStart();

        @ArgumentParser.ParameterDescription(valueName="end", description="index of last sentence")
        @ArgumentParser.OptionalParameter
        public Integer getEnd();
    }
}

