/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.ad;

import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.formats.ad.ADNameSampleStream;
import chalk.tools.namefind.NameSample;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;

public class ADNameSampleStreamFactory
extends LanguageSampleStreamFactory<NameSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "ad", new ADNameSampleStreamFactory(Parameters.class));
    }

    protected <P> ADNameSampleStreamFactory(Class<P> clazz) {
        super(clazz);
    }

    @Override
    public ObjectStream<NameSample> create(String[] stringArray) {
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        this.language = parameters.getLang();
        FileInputStream fileInputStream = CmdLineUtil.openInFile(parameters.getData());
        PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(fileInputStream.getChannel(), parameters.getEncoding());
        return new ADNameSampleStream(plainTextByLineStream, parameters.getSplitHyphenatedTokens());
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData", description="data to be used, usually a file name.")
        public File getData();

        @ArgumentParser.ParameterDescription(valueName="split", description="if true all hyphenated tokens will be separated (default true)")
        @ArgumentParser.OptionalParameter(defaultValue="true")
        public Boolean getSplitHyphenatedTokens();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();
    }
}

