/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.ad;

import chalk.tools.formats.ad.ADSentenceStream;
import chalk.tools.postag.POSSample;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ADPOSSampleStream
implements ObjectStream<POSSample> {
    private final ObjectStream<ADSentenceStream.Sentence> adSentenceStream;
    private boolean expandME;
    private boolean isIncludeFeatures;

    public ADPOSSampleStream(ObjectStream<String> objectStream, boolean bl, boolean bl2) {
        this.adSentenceStream = new ADSentenceStream(objectStream);
        this.expandME = bl;
        this.isIncludeFeatures = bl2;
    }

    public ADPOSSampleStream(InputStream inputStream, String string, boolean bl, boolean bl2) {
        try {
            this.adSentenceStream = new ADSentenceStream(new PlainTextByLineStream(inputStream, string));
            this.expandME = bl;
            this.isIncludeFeatures = bl2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    @Override
    public POSSample read() throws IOException {
        ADSentenceStream.Sentence sentence = this.adSentenceStream.read();
        if (sentence != null) {
            ADSentenceStream.SentenceParser.Node node = sentence.getRoot();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            this.process(node, arrayList, arrayList2);
            return new POSSample(arrayList, arrayList2);
        }
        return null;
    }

    private void process(ADSentenceStream.SentenceParser.Node node, List<String> list, List<String> list2) {
        if (node != null) {
            for (ADSentenceStream.SentenceParser.TreeElement treeElement : node.getElements()) {
                if (treeElement.isLeaf()) {
                    this.processLeaf((ADSentenceStream.SentenceParser.Leaf)treeElement, list, list2);
                    continue;
                }
                this.process((ADSentenceStream.SentenceParser.Node)treeElement, list, list2);
            }
        }
    }

    private void processLeaf(ADSentenceStream.SentenceParser.Leaf leaf, List<String> list, List<String> list2) {
        if (leaf != null) {
            String string = leaf.getLexeme();
            String string2 = leaf.getFunctionalTag();
            if (string2 == null) {
                string2 = leaf.getLexeme();
            }
            if (this.isIncludeFeatures && leaf.getMorphologicalTag() != null) {
                string2 = string2 + " " + leaf.getMorphologicalTag();
            }
            if ((string2 = string2.replaceAll("\\s+", "=")) == null) {
                string2 = string;
            }
            if (this.expandME && string.contains("_")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
                if (stringTokenizer.countTokens() > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
                    ArrayList<String> arrayList2 = new ArrayList<String>(stringTokenizer.countTokens());
                    arrayList.add(stringTokenizer.nextToken());
                    arrayList2.add("B-" + string2);
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                        arrayList2.add("I-" + string2);
                    }
                    list.addAll(arrayList);
                    list2.addAll(arrayList2);
                } else {
                    list.add(string);
                    list2.add(string2);
                }
            } else {
                list.add(string);
                list2.add(string2);
            }
        }
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.adSentenceStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.adSentenceStream.close();
    }
}

