/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.ad;

import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.formats.ad.ADPOSSampleStream;
import chalk.tools.postag.POSSample;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;

public class ADPOSSampleStreamFactory
extends LanguageSampleStreamFactory<POSSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, "ad", new ADPOSSampleStreamFactory(Parameters.class));
    }

    protected <P> ADPOSSampleStreamFactory(Class<P> clazz) {
        super(clazz);
    }

    @Override
    public ObjectStream<POSSample> create(String[] stringArray) {
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        this.language = parameters.getLang();
        FileInputStream fileInputStream = CmdLineUtil.openInFile(parameters.getData());
        PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(fileInputStream.getChannel(), parameters.getEncoding());
        ADPOSSampleStream aDPOSSampleStream = new ADPOSSampleStream(plainTextByLineStream, parameters.getExpandME(), parameters.getIncludeFeatures());
        return aDPOSSampleStream;
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData", description="data to be used, usually a file name.")
        public File getData();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="expandME", description="expand multiword expressions.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getExpandME();

        @ArgumentParser.ParameterDescription(valueName="includeFeatures", description="combine POS Tags with word features, like number and gender.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getIncludeFeatures();
    }
}

