/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.ad;

import chalk.tools.formats.ad.ADSentenceStream;
import chalk.tools.sentdetect.SentenceSample;
import chalk.tools.sentdetect.lang.Factory;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import chalk.tools.util.Span;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ADSentenceSampleStream
implements ObjectStream<SentenceSample> {
    private final ObjectStream<ADSentenceStream.Sentence> adSentenceStream;
    private int text = -1;
    private int para = -1;
    private boolean isSameText;
    private boolean isSamePara;
    private ADSentenceStream.Sentence sent;
    private boolean isIncludeTitles = true;
    private boolean isTitle;
    private final char[] ptEosCharacters;
    private Pattern meta1 = Pattern.compile("^(?:[a-zA-Z\\-]*(\\d+)).*?p=(\\d+).*");

    public ADSentenceSampleStream(ObjectStream<String> objectStream, boolean bl) {
        this.adSentenceStream = new ADSentenceStream(objectStream);
        this.ptEosCharacters = Factory.ptEosCharacters;
        Arrays.sort(this.ptEosCharacters);
        this.isIncludeTitles = bl;
    }

    public ADSentenceSampleStream(FileInputStream fileInputStream, String string, boolean bl) {
        try {
            this.adSentenceStream = new ADSentenceStream(new PlainTextByLineStream((InputStream)fileInputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        this.ptEosCharacters = Factory.ptEosCharacters;
        Arrays.sort(this.ptEosCharacters);
        this.isIncludeTitles = bl;
    }

    @Override
    public SentenceSample read() throws IOException {
        if (this.sent == null) {
            this.sent = this.adSentenceStream.read();
            this.updateMeta();
            if (this.sent == null) {
                return null;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Span> arrayList = new ArrayList<Span>();
        do {
            if ((!this.isTitle || this.isTitle && this.isIncludeTitles) && this.hasPunctuation(this.sent.getText())) {
                int n = stringBuilder.length();
                stringBuilder.append(this.sent.getText());
                arrayList.add(new Span(n, stringBuilder.length()));
                stringBuilder.append(" ");
            }
            this.sent = this.adSentenceStream.read();
            this.updateMeta();
        } while (this.isSamePara || this.isSameText);
        String string = stringBuilder.length() > 0 ? stringBuilder.substring(0, stringBuilder.length() - 1) : stringBuilder.toString();
        return new SentenceSample(string, arrayList.toArray(new Span[arrayList.size()]));
    }

    private boolean hasPunctuation(String string) {
        char c;
        return (string = string.trim()).length() > 0 && Arrays.binarySearch(this.ptEosCharacters, c = string.charAt(string.length() - 1)) >= 0;
    }

    private void updateMeta() {
        if (this.sent != null) {
            String string = this.sent.getMetadata();
            Matcher matcher = this.meta1.matcher(string);
            if (!matcher.matches()) {
                throw new RuntimeException("Invalid metadata: " + string);
            }
            int n = Integer.parseInt(matcher.group(1));
            int n2 = Integer.parseInt(matcher.group(2));
            this.isSameText = false;
            this.isSamePara = false;
            if (n == this.text) {
                this.isSameText = true;
            }
            if (this.isSameText && n2 == this.para) {
                this.isSamePara = true;
            }
            this.isTitle = string.contains("title");
            this.text = n;
            this.para = n2;
        } else {
            this.isSameText = false;
            this.isSamePara = false;
        }
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.adSentenceStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.adSentenceStream.close();
    }
}

