/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.ad;

import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.formats.ad.ADSentenceSampleStream;
import chalk.tools.sentdetect.SentenceSample;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;

public class ADSentenceSampleStreamFactory
extends LanguageSampleStreamFactory<SentenceSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentenceSample.class, "ad", new ADSentenceSampleStreamFactory(Parameters.class));
    }

    protected <P> ADSentenceSampleStreamFactory(Class<P> clazz) {
        super(clazz);
    }

    @Override
    public ObjectStream<SentenceSample> create(String[] stringArray) {
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        this.language = parameters.getLang();
        boolean bl = parameters.getIncludeTitles();
        FileInputStream fileInputStream = CmdLineUtil.openInFile(parameters.getData());
        PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(fileInputStream.getChannel(), parameters.getEncoding());
        ADSentenceSampleStream aDSentenceSampleStream = new ADSentenceSampleStream(plainTextByLineStream, bl);
        return aDSentenceSampleStream;
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData", description="data to be used, usually a file name.")
        public File getData();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="includeTitles", description="if true will include sentences marked as headlines.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getIncludeTitles();
    }
}

