/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.ad;

import chalk.tools.util.FilterObjectStream;
import chalk.tools.util.ObjectStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ADSentenceStream
extends FilterObjectStream<String, Sentence> {
    private static final Pattern sentStart = Pattern.compile("<s[^>]*>");
    private static final Pattern sentEnd = Pattern.compile("</s>");
    private static final Pattern extEnd = Pattern.compile("</ext>");
    private static final Pattern titleStart = Pattern.compile("<t[^>]*>");
    private static final Pattern titleEnd = Pattern.compile("</t>");
    private static final Pattern boxStart = Pattern.compile("<caixa[^>]*>");
    private static final Pattern boxEnd = Pattern.compile("</caixa>");
    private static final Pattern paraStart = Pattern.compile("<p[^>]*>");
    private static final Pattern textStart = Pattern.compile("<ext[^>]*>");
    private SentenceParser parser = new SentenceParser();
    private int paraID = 0;
    private boolean isTitle = false;
    private boolean isBox = false;

    public ADSentenceStream(ObjectStream<String> objectStream) {
        super(objectStream);
    }

    @Override
    public Sentence read() throws IOException {
        block20: {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            while (true) {
                String string;
                if ((string = (String)this.samples.read()) != null) {
                    if (bl) {
                        if (sentEnd.matcher(string).matches() || extEnd.matcher(string).matches()) {
                            bl = false;
                        } else if (!string.startsWith("A1")) {
                            stringBuilder.append(string).append('\n');
                        }
                    } else if (sentStart.matcher(string).matches()) {
                        bl = true;
                    } else if (paraStart.matcher(string).matches()) {
                        ++this.paraID;
                    } else if (titleStart.matcher(string).matches()) {
                        this.isTitle = true;
                    } else if (titleEnd.matcher(string).matches()) {
                        this.isTitle = false;
                    } else if (textStart.matcher(string).matches()) {
                        this.paraID = 0;
                    } else if (boxStart.matcher(string).matches()) {
                        this.isBox = true;
                    } else if (boxEnd.matcher(string).matches()) {
                        this.isBox = false;
                    }
                    if (bl || stringBuilder.length() <= 0) continue;
                    return this.parser.parse(stringBuilder.toString(), this.paraID, this.isTitle, this.isBox);
                }
                if (!bl) break block20;
                if (stringBuilder.length() > 0) break;
            }
            return this.parser.parse(stringBuilder.toString(), this.paraID, this.isTitle, this.isBox);
        }
        return null;
    }

    public static class SentenceParser {
        private Pattern nodePattern = Pattern.compile("([=-]*)([^:=]+:[^\\(\\s]+)(\\(([^\\)]+)\\))?\\s*(?:(\\((<.+>)\\))*)\\s*$");
        private Pattern leafPattern = Pattern.compile("^([=-]*)([^:=]+):([^\\(\\s]+)\\([\"'](.+)[\"']\\s*((?:<.+>)*)\\s*([^\\)]+)?\\)\\s+(.+)");
        private Pattern bizarreLeafPattern = Pattern.compile("^([=-]*)([^:=]+=[^\\(\\s]+)\\(([\"'].+[\"'])?\\s*([^\\)]+)?\\)\\s+(.+)");
        private Pattern punctuationPattern = Pattern.compile("^(=*)(\\W+)$");
        private String text;
        private String meta;

        public Sentence parse(String string, int n, boolean bl, boolean bl2) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            Sentence sentence = new Sentence();
            Node node = new Node();
            try {
                Object object;
                Object object2;
                Object object3;
                String string2 = bufferedReader.readLine();
                boolean bl3 = false;
                while (!string2.startsWith("SOURCE")) {
                    if (string2.equals("&&")) {
                        bl3 = true;
                        break;
                    }
                    string2 = bufferedReader.readLine();
                    if (string2 != null) continue;
                    return null;
                }
                if (!bl3) {
                    object3 = string2.substring(7);
                    string2 = bufferedReader.readLine();
                    int n2 = string2.indexOf(" ");
                    this.text = string2.substring(n2 + 1).trim();
                    this.text = this.fixPunctuation(this.text);
                    object2 = "";
                    if (bl) {
                        object2 = " title";
                    }
                    object = "";
                    if (bl2) {
                        object = " box";
                    }
                    if (n2 > 0) {
                        this.meta = string2.substring(0, n2) + " p=" + n + (String)object2 + (String)object + (String)object3;
                    }
                }
                sentence.setText(this.text);
                sentence.setMetadata(this.meta);
                string2 = bufferedReader.readLine();
                while (string2 != null && string2.startsWith("###")) {
                    string2 = bufferedReader.readLine();
                }
                object3 = new Stack();
                node.setSyntacticTag("ROOT");
                node.setLevel(0);
                ((Vector)object3).add(node);
                while (string2 != null && string2.length() != 0 && !string2.startsWith("</s>") && !string2.equals("&&")) {
                    TreeElement treeElement = this.getElement(string2);
                    if (treeElement != null) {
                        while (!((Vector)object3).isEmpty() && treeElement.getLevel() > 0 && treeElement.getLevel() <= ((Node)((Stack)object3).peek()).getLevel()) {
                            object2 = (Node)((Stack)object3).pop();
                        }
                        if (treeElement.isLeaf()) {
                            if (((Vector)object3).isEmpty()) {
                                node.addElement(treeElement);
                            } else {
                                object2 = (Node)((Stack)object3).peek();
                                if (treeElement.level == 0) {
                                    ((Node)((Vector)object3).firstElement()).addElement(treeElement);
                                } else {
                                    object = null;
                                    int n3 = ((Vector)object3).size() - 1;
                                    while (object == null) {
                                        if (((TreeElement)object2).getLevel() < treeElement.getLevel()) {
                                            object = object2;
                                            continue;
                                        }
                                        if (--n3 > -1) {
                                            object2 = (Node)((Vector)object3).get(n3);
                                            continue;
                                        }
                                        object = (Node)((Vector)object3).firstElement();
                                    }
                                    ((Node)object).addElement(treeElement);
                                }
                            }
                        } else {
                            if (!((Vector)object3).isEmpty() && ((Node)((Stack)object3).peek()).getLevel() < treeElement.getLevel()) {
                                ((Node)((Stack)object3).peek()).addElement(treeElement);
                            } else {
                                System.err.println("should not happen!");
                            }
                            ((Stack)object3).push((Node)treeElement);
                        }
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            catch (Exception exception) {
                System.err.println(string);
                exception.printStackTrace();
                return sentence;
            }
            sentence.setRoot(node);
            return sentence;
        }

        private String fixPunctuation(String string) {
            string = string.replaceAll("\\\u00bb\\s+\\.", "\u00bb.");
            string = string.replaceAll("\\\u00bb\\s+\\,", "\u00bb,");
            return string;
        }

        public TreeElement getElement(String string) {
            Matcher matcher = this.nodePattern.matcher(string);
            if (matcher.matches()) {
                int n = matcher.group(1).length() + 1;
                String string2 = matcher.group(2);
                Node node = new Node();
                node.setLevel(n);
                node.setSyntacticTag(string2);
                return node;
            }
            Matcher matcher2 = this.leafPattern.matcher(string);
            if (matcher2.matches()) {
                int n = matcher2.group(1).length() + 1;
                String string3 = matcher2.group(2);
                String string4 = matcher2.group(3);
                String string5 = matcher2.group(4);
                String string6 = matcher2.group(5);
                String string7 = matcher2.group(6);
                String string8 = matcher2.group(7);
                Leaf leaf = new Leaf();
                leaf.setLevel(n);
                leaf.setSyntacticTag(string3);
                leaf.setFunctionalTag(string4);
                leaf.setSecondaryTag(string6);
                leaf.setMorphologicalTag(string7);
                leaf.setLexeme(string8);
                leaf.setLemma(string5);
                return leaf;
            }
            Matcher matcher3 = this.punctuationPattern.matcher(string);
            if (matcher3.matches()) {
                int n = matcher3.group(1).length() + 1;
                String string9 = matcher3.group(2);
                Leaf leaf = new Leaf();
                leaf.setLevel(n);
                leaf.setLexeme(string9);
                return leaf;
            }
            if (string.equals("_") || string.startsWith("<lixo") || string.startsWith("pause")) {
                return null;
            }
            if (string.startsWith("=")) {
                Matcher matcher4 = this.bizarreLeafPattern.matcher(string);
                if (matcher4.matches()) {
                    int n = matcher4.group(1).length() + 1;
                    String string10 = matcher4.group(2);
                    String string11 = matcher4.group(3);
                    String string12 = matcher4.group(4);
                    String string13 = matcher4.group(5);
                    Leaf leaf = new Leaf();
                    leaf.setLevel(n);
                    leaf.setSyntacticTag(string10);
                    leaf.setMorphologicalTag(string12);
                    leaf.setLexeme(string13);
                    if (string11 != null) {
                        if (string11.length() > 2) {
                            string11 = string11.substring(1, string11.length() - 1);
                        }
                        leaf.setLemma(string11);
                    }
                    return leaf;
                }
                int n = string.lastIndexOf("=") + 1;
                String string14 = string.substring(n + 1);
                if (string14.matches("\\w.*?[\\.<>].*")) {
                    return null;
                }
                Leaf leaf = new Leaf();
                leaf.setLevel(n + 1);
                leaf.setSyntacticTag("");
                leaf.setMorphologicalTag("");
                leaf.setLexeme(string14);
                return leaf;
            }
            System.err.println("Couldn't parse leaf: " + string);
            Leaf leaf = new Leaf();
            leaf.setLevel(1);
            leaf.setSyntacticTag("");
            leaf.setMorphologicalTag("");
            leaf.setLexeme(string);
            return leaf;
        }

        public class Leaf
        extends TreeElement {
            private String word;
            private String lemma;
            private String secondaryTag;
            private String functionalTag;

            @Override
            public boolean isLeaf() {
                return true;
            }

            public void setFunctionalTag(String string) {
                this.functionalTag = string;
            }

            public String getFunctionalTag() {
                return this.functionalTag;
            }

            public void setSecondaryTag(String string) {
                this.secondaryTag = string;
            }

            public String getSecondaryTag() {
                return this.secondaryTag;
            }

            public void setLexeme(String string) {
                this.word = string;
            }

            public String getLexeme() {
                return this.word;
            }

            private String emptyOrString(String string, String string2, String string3) {
                if (string == null) {
                    return "";
                }
                return string2 + string + string3;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < this.getLevel(); ++i) {
                    stringBuilder.append("=");
                }
                if (this.getSyntacticTag() != null) {
                    stringBuilder.append(this.getSyntacticTag()).append(":").append(this.getFunctionalTag()).append("(").append(this.emptyOrString(this.getLemma(), "'", "' ")).append(this.emptyOrString(this.getSecondaryTag(), "", " ")).append(this.getMorphologicalTag()).append(") ");
                }
                stringBuilder.append(this.word).append("\n");
                return stringBuilder.toString();
            }

            public void setLemma(String string) {
                this.lemma = string;
            }

            public String getLemma() {
                return this.lemma;
            }
        }

        public class Node
        extends TreeElement {
            private List<TreeElement> elems;

            public Node() {
                this.elems = new ArrayList<TreeElement>();
            }

            public void addElement(TreeElement treeElement) {
                this.elems.add(treeElement);
            }

            public TreeElement[] getElements() {
                return this.elems.toArray(new TreeElement[this.elems.size()]);
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < this.getLevel(); ++i) {
                    stringBuilder.append("=");
                }
                stringBuilder.append(this.getSyntacticTag());
                if (this.getMorphologicalTag() != null) {
                    stringBuilder.append(this.getMorphologicalTag());
                }
                stringBuilder.append("\n");
                for (TreeElement treeElement : this.elems) {
                    stringBuilder.append(treeElement.toString());
                }
                return stringBuilder.toString();
            }
        }

        public abstract class TreeElement {
            private String syntacticTag;
            private String morphologicalTag;
            private int level;

            public boolean isLeaf() {
                return false;
            }

            public void setSyntacticTag(String string) {
                this.syntacticTag = string;
            }

            public String getSyntacticTag() {
                return this.syntacticTag;
            }

            public void setLevel(int n) {
                this.level = n;
            }

            public int getLevel() {
                return this.level;
            }

            public void setMorphologicalTag(String string) {
                this.morphologicalTag = string;
            }

            public String getMorphologicalTag() {
                return this.morphologicalTag;
            }
        }
    }

    public static class Sentence {
        private String text;
        private SentenceParser.Node root;
        private String metadata;
        public static final String META_LABEL_FINAL = "final";

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public SentenceParser.Node getRoot() {
            return this.root;
        }

        public void setRoot(SentenceParser.Node node) {
            this.root = node;
        }

        public void setMetadata(String string) {
            this.metadata = string;
        }

        public String getMetadata() {
            return this.metadata;
        }
    }
}

