/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.convert;

import chalk.tools.sentdetect.SentenceSample;
import chalk.tools.tokenize.Detokenizer;
import chalk.tools.util.FilterObjectStream;
import chalk.tools.util.ObjectStream;
import java.io.IOException;
import java.util.ArrayList;

public abstract class AbstractToSentenceSampleStream<T>
extends FilterObjectStream<T, SentenceSample> {
    private final Detokenizer detokenizer;
    private final int chunkSize;

    AbstractToSentenceSampleStream(Detokenizer detokenizer, ObjectStream<T> objectStream, int n) {
        super(objectStream);
        if (detokenizer == null) {
            throw new IllegalArgumentException("detokenizer must not be null!");
        }
        this.detokenizer = detokenizer;
        if (n < 0) {
            throw new IllegalArgumentException("chunkSize must be zero or larger but was " + n + "!");
        }
        this.chunkSize = n > 0 ? n : Integer.MAX_VALUE;
    }

    protected abstract String[] toSentence(T var1);

    @Override
    public SentenceSample read() throws IOException {
        Object t;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; (t = this.samples.read()) != null && i < this.chunkSize; ++i) {
            arrayList.add(this.toSentence(t));
        }
        if (arrayList.size() > 0) {
            return new SentenceSample(this.detokenizer, (String[][])arrayList.toArray((T[])new String[arrayList.size()][]));
        }
        if (t != null) {
            return this.read();
        }
        return null;
    }
}

