/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.frenchtreebank;

import chalk.tools.parser.Constituent;
import chalk.tools.parser.Parse;
import chalk.tools.util.Span;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ConstitDocumentHandler
extends DefaultHandler {
    private static final String SENT_ELEMENT_NAME = "SENT";
    private static final String WORD_ELEMENT_NAME = "w";
    private static final String SENT_TYPE_NAME = "S";
    private final List<Parse> parses;
    private boolean insideSentenceElement;
    private final StringBuilder tokenBuffer = new StringBuilder();
    private final StringBuilder text = new StringBuilder();
    private int offset;
    private final Stack<Constituent> stack = new Stack();
    private final List<Constituent> cons = new LinkedList<Constituent>();
    private String cat;
    private String subcat;

    ConstitDocumentHandler(List<Parse> list) {
        this.parses = list;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string3;
        if (SENT_ELEMENT_NAME.equals(string3)) {
            this.text.setLength(0);
            this.offset = 0;
            this.stack.clear();
            this.cons.clear();
            string4 = SENT_TYPE_NAME;
            this.insideSentenceElement = true;
        } else if (WORD_ELEMENT_NAME.equals(string3)) {
            String string5;
            String string6;
            String string7 = attributes.getValue("cat");
            if (string7 != null && string7.length() > 0) {
                this.cat = string7;
            }
            if ((string6 = attributes.getValue("subcat")) != null && string6.length() > 0) {
                this.subcat = string6;
            }
            string4 = this.cat != null ? this.cat + (this.subcat != null ? this.subcat : "") : ((string5 = attributes.getValue("catint")) != null ? this.cat + (string5 != null ? string5 : "") : this.cat + this.subcat);
        }
        this.stack.push(new Constituent(string4, new Span(this.offset, this.offset)));
        this.tokenBuffer.setLength(0);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.tokenBuffer.append(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        boolean bl = true;
        if (this.insideSentenceElement) {
            int n;
            Object object;
            if (WORD_ELEMENT_NAME.equals(string3)) {
                object = this.tokenBuffer.toString().trim();
                if (((String)object).length() > 0) {
                    this.cons.add(new Constituent("TK", new Span(this.offset, this.offset + ((String)object).length())));
                    this.text.append((String)object).append(" ");
                    this.offset += ((String)object).length() + 1;
                } else {
                    bl = false;
                }
            }
            object = this.stack.pop();
            if (bl && (n = ((Constituent)object).getSpan().getStart()) < this.offset) {
                this.cons.add(new Constituent(((Constituent)object).getLabel(), new Span(n, this.offset - 1)));
            }
            if (SENT_ELEMENT_NAME.equals(string3)) {
                String string4 = this.text.toString();
                int n2 = -1;
                Parse parse = new Parse(string4, new Span(0, string4.length()), "TOP", 1.0, 0);
                for (int i = 0; i < this.cons.size(); ++i) {
                    Constituent constituent = this.cons.get(i);
                    String string5 = constituent.getLabel();
                    if (string5.equals("TOP")) continue;
                    if (string5 == "TK") {
                        ++n2;
                    }
                    Parse parse2 = new Parse(string4, constituent.getSpan(), string5, 1.0, n2);
                    parse.insert(parse2);
                }
                this.parses.add(parse);
                this.insideSentenceElement = false;
            }
            this.tokenBuffer.setLength(0);
        }
    }
}

