/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.frenchtreebank;

import chalk.tools.formats.frenchtreebank.ConstitDocumentHandler;
import chalk.tools.parser.Parse;
import chalk.tools.util.FilterObjectStream;
import chalk.tools.util.ObjectStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConstitParseSampleStream
extends FilterObjectStream<byte[], Parse> {
    private SAXParser saxParser;
    private List<Parse> parses = new ArrayList<Parse>();

    protected ConstitParseSampleStream(ObjectStream<byte[]> objectStream) {
        super(objectStream);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            this.saxParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException);
        }
    }

    @Override
    public Parse read() throws IOException {
        byte[] byArray;
        if (this.parses.isEmpty() && (byArray = (byte[])this.samples.read()) != null) {
            ArrayList<Parse> arrayList = new ArrayList<Parse>();
            try {
                this.saxParser.parse((InputStream)new ByteArrayInputStream(byArray), (DefaultHandler)new ConstitDocumentHandler(arrayList));
            }
            catch (SAXException sAXException) {
                throw (IOException)new IOException(sAXException.getMessage()).initCause(sAXException);
            }
            this.parses.addAll(arrayList);
        }
        if (this.parses.size() > 0) {
            return this.parses.remove(0);
        }
        return null;
    }
}

