/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.muc;

import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.cmdline.namefind.TokenNameFinderModelLoader;
import chalk.tools.cmdline.params.LanguageFormatParams;
import chalk.tools.cmdline.parser.ParserModelLoader;
import chalk.tools.cmdline.tokenizer.TokenizerModelLoader;
import chalk.tools.coref.CorefSample;
import chalk.tools.formats.DirectorySampleStream;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.formats.convert.FileToStringSampleStream;
import chalk.tools.formats.muc.FullParseCorefEnhancerStream;
import chalk.tools.formats.muc.MucCorefSampleStream;
import chalk.tools.formats.muc.MucMentionInserterStream;
import chalk.tools.formats.muc.NameFinderCorefEnhancerStream;
import chalk.tools.namefind.NameFinderME;
import chalk.tools.namefind.TokenNameFinder;
import chalk.tools.namefind.TokenNameFinderModel;
import chalk.tools.parser.Parser;
import chalk.tools.parser.ParserFactory;
import chalk.tools.parser.ParserModel;
import chalk.tools.tokenize.TokenizerME;
import chalk.tools.tokenize.TokenizerModel;
import chalk.tools.util.ObjectStream;
import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Muc6FullParseCorefSampleStreamFactory
extends LanguageSampleStreamFactory<CorefSample> {
    protected Muc6FullParseCorefSampleStreamFactory() {
        super(Parameters.class);
    }

    @Override
    public ObjectStream<CorefSample> create(String[] stringArray) {
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        this.language = parameters.getLang();
        ParserModel parserModel = (ParserModel)new ParserModelLoader().load(parameters.getParserModel());
        Parser parser = ParserFactory.create(parserModel);
        TokenizerModel tokenizerModel = (TokenizerModel)new TokenizerModelLoader().load(parameters.getTokenizerModel());
        TokenizerME tokenizerME = new TokenizerME(tokenizerModel);
        FileToStringSampleStream fileToStringSampleStream = new FileToStringSampleStream(new DirectorySampleStream(parameters.getData(), new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".sgm");
            }
        }, false), Charset.forName("UTF-8"));
        MucCorefSampleStream mucCorefSampleStream = new MucCorefSampleStream(tokenizerME, fileToStringSampleStream);
        FullParseCorefEnhancerStream fullParseCorefEnhancerStream = new FullParseCorefEnhancerStream(parser, mucCorefSampleStream);
        HashMap<String, File> hashMap = new HashMap<String, File>();
        hashMap.put("person", parameters.getPersonModel());
        hashMap.put("organization", parameters.getOrganizationModel());
        ArrayList<NameFinderME> arrayList = new ArrayList<NameFinderME>();
        ArrayList arrayList2 = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            arrayList.add(new NameFinderME((TokenNameFinderModel)new TokenNameFinderModelLoader().load((File)entry.getValue())));
            arrayList2.add(entry.getKey());
        }
        return new MucMentionInserterStream(new NameFinderCorefEnhancerStream(arrayList.toArray(new TokenNameFinder[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]), fullParseCorefEnhancerStream));
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(CorefSample.class, "muc6full", new Muc6FullParseCorefSampleStreamFactory());
    }

    static interface Parameters
    extends LanguageFormatParams {
        @ArgumentParser.ParameterDescription(valueName="modelFile")
        public File getParserModel();

        @ArgumentParser.ParameterDescription(valueName="modelFile")
        public File getTokenizerModel();

        @ArgumentParser.ParameterDescription(valueName="modelFile")
        public File getPersonModel();

        @ArgumentParser.ParameterDescription(valueName="modelFile")
        public File getOrganizationModel();
    }
}

