/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.muc;

import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.cmdline.params.LanguageFormatParams;
import chalk.tools.cmdline.tokenizer.TokenizerModelLoader;
import chalk.tools.formats.DirectorySampleStream;
import chalk.tools.formats.LanguageSampleStreamFactory;
import chalk.tools.formats.convert.FileToStringSampleStream;
import chalk.tools.formats.muc.MucNameSampleStream;
import chalk.tools.namefind.NameSample;
import chalk.tools.tokenize.TokenizerME;
import chalk.tools.tokenize.TokenizerModel;
import chalk.tools.util.ObjectStream;
import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;

public class Muc6NameSampleStreamFactory
extends LanguageSampleStreamFactory<NameSample> {
    protected Muc6NameSampleStreamFactory() {
        super(Parameters.class);
    }

    @Override
    public ObjectStream<NameSample> create(String[] stringArray) {
        Parameters parameters = ArgumentParser.parse(stringArray, Parameters.class);
        this.language = parameters.getLang();
        TokenizerModel tokenizerModel = (TokenizerModel)new TokenizerModelLoader().load(parameters.getTokenizerModel());
        TokenizerME tokenizerME = new TokenizerME(tokenizerModel);
        FileToStringSampleStream fileToStringSampleStream = new FileToStringSampleStream(new DirectorySampleStream(parameters.getData(), new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".sgm");
            }
        }, false), Charset.forName("UTF-8"));
        return new MucNameSampleStream(tokenizerME, fileToStringSampleStream);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "muc6", new Muc6NameSampleStreamFactory());
    }

    static interface Parameters
    extends LanguageFormatParams {
        @ArgumentParser.ParameterDescription(valueName="modelFile")
        public File getTokenizerModel();
    }
}

