/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.muc;

import chalk.tools.formats.muc.MucElementNames;
import chalk.tools.formats.muc.RawCorefSample;
import chalk.tools.formats.muc.SgmlParser;
import chalk.tools.tokenize.Tokenizer;
import chalk.tools.util.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

class MucCorefContentHandler
extends SgmlParser.ContentHandler {
    static final String COREF_ELEMENT = "COREF";
    private final Tokenizer tokenizer;
    private final List<RawCorefSample> samples;
    boolean isInsideContentElement = false;
    private final List<String> text = new ArrayList<String>();
    private Stack<CorefMention> mentionStack = new Stack();
    private List<CorefMention> mentions = new ArrayList<CorefMention>();
    private Map<Integer, Integer> idMap = new HashMap<Integer, Integer>();
    private RawCorefSample sample;

    MucCorefContentHandler(Tokenizer tokenizer, List<RawCorefSample> list) {
        this.tokenizer = tokenizer;
        this.samples = list;
    }

    private int resolveId(int n) {
        Integer n2 = this.idMap.get(n);
        if (n2 != null) {
            if (n == n2) {
                return n;
            }
            return this.resolveId(n2);
        }
        return -1;
    }

    @Override
    public void startElement(String string, Map<String, String> map) {
        if ("DOC".equals(string)) {
            this.idMap.clear();
            this.sample = new RawCorefSample(new ArrayList<String>(), new ArrayList<CorefMention[]>());
        }
        if (MucElementNames.CONTENT_ELEMENTS.contains(string)) {
            this.isInsideContentElement = true;
        }
        if (COREF_ELEMENT.equals(string)) {
            int n;
            int n2 = this.text.size();
            String string2 = map.get("ID");
            String string3 = map.get("REF");
            if (string2 != null) {
                n = Integer.parseInt(string2);
                if (string3 == null) {
                    this.idMap.put(n, n);
                } else {
                    int n3 = Integer.parseInt(string3);
                    this.idMap.put(n, n3);
                }
            } else {
                n = -1;
            }
            this.mentionStack.push(new CorefMention(new Span(n2, n2), n, map.get("MIN")));
        }
    }

    @Override
    public void characters(CharSequence charSequence) {
        if (this.isInsideContentElement) {
            String[] stringArray = this.tokenizer.tokenize(((Object)charSequence).toString());
            this.text.addAll(Arrays.asList(stringArray));
        }
    }

    @Override
    public void endElement(String string) {
        if (COREF_ELEMENT.equals(string)) {
            CorefMention corefMention = this.mentionStack.pop();
            corefMention.span = new Span(corefMention.span.getStart(), this.text.size());
            this.mentions.add(corefMention);
        }
        if (MucElementNames.CONTENT_ELEMENTS.contains(string)) {
            this.sample.getTexts().add(this.text.toArray(new String[this.text.size()]));
            this.sample.getMentions().add(this.mentions.toArray(new CorefMention[this.mentions.size()]));
            this.mentions.clear();
            this.text.clear();
            this.isInsideContentElement = false;
        }
        if ("DOC".equals(string)) {
            for (CorefMention[] corefMentionArray : this.sample.getMentions()) {
                for (int i = 0; i < corefMentionArray.length; ++i) {
                    corefMentionArray[i].id = this.resolveId(corefMentionArray[i].id);
                }
            }
            this.samples.add(this.sample);
        }
    }

    static class CorefMention {
        Span span;
        int id;
        String min;

        CorefMention(Span span, int n, String string) {
            this.span = span;
            this.id = n;
            this.min = string;
        }
    }
}

