/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.muc;

import chalk.tools.formats.muc.DocumentSplitterStream;
import chalk.tools.formats.muc.MucCorefContentHandler;
import chalk.tools.formats.muc.RawCorefSample;
import chalk.tools.formats.muc.SgmlParser;
import chalk.tools.tokenize.Tokenizer;
import chalk.tools.util.FilterObjectStream;
import chalk.tools.util.ObjectStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class MucCorefSampleStream
extends FilterObjectStream<String, RawCorefSample> {
    private final Tokenizer tokenizer;
    private List<RawCorefSample> documents = new ArrayList<RawCorefSample>();

    public MucCorefSampleStream(Tokenizer tokenizer, ObjectStream<String> objectStream) {
        super(new DocumentSplitterStream(objectStream));
        this.tokenizer = tokenizer;
    }

    @Override
    public RawCorefSample read() throws IOException {
        String string;
        if (this.documents.isEmpty() && (string = (String)this.samples.read()) != null) {
            new SgmlParser().parse(new StringReader(string), new MucCorefContentHandler(this.tokenizer, this.documents));
        }
        if (this.documents.size() > 0) {
            return this.documents.remove(0);
        }
        return null;
    }
}

