/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.muc;

import chalk.tools.coref.CorefSample;
import chalk.tools.coref.mention.DefaultParse;
import chalk.tools.coref.mention.Mention;
import chalk.tools.coref.mention.MentionFinder;
import chalk.tools.coref.mention.PTBHeadFinder;
import chalk.tools.coref.mention.PTBMentionFinder;
import chalk.tools.formats.muc.MucCorefContentHandler;
import chalk.tools.formats.muc.RawCorefSample;
import chalk.tools.parser.Parse;
import chalk.tools.util.FilterObjectStream;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.Span;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MucMentionInserterStream
extends FilterObjectStream<RawCorefSample, CorefSample> {
    private static Set<String> entitySet = new HashSet<String>(Arrays.asList(DefaultParse.NAME_TYPES));
    private final MentionFinder mentionFinder = PTBMentionFinder.getInstance(PTBHeadFinder.getInstance());

    protected MucMentionInserterStream(ObjectStream<RawCorefSample> objectStream) {
        super(objectStream);
    }

    private static Span getMinSpan(Parse parse, MucCorefContentHandler.CorefMention corefMention) {
        String string = corefMention.min;
        if (string != null) {
            int n = parse.toString().indexOf(string);
            int n2 = n + string.length();
            Parse[] parseArray = parse.getTagNodes();
            int n3 = -1;
            int n4 = -1;
            for (int i = 0; i < parseArray.length; ++i) {
                if (parseArray[i].getSpan().getStart() == n) {
                    n3 = i;
                }
                if (parseArray[i].getSpan().getEnd() != n2) continue;
                n4 = i + 1;
                break;
            }
            if (n3 != -1 && n4 != -1) {
                return new Span(n3, n4);
            }
        }
        return null;
    }

    public static boolean addMention(int n, Span span, Parse[] parseArray) {
        Parse parse;
        boolean bl = false;
        Parse parse2 = parseArray[span.getStart()];
        Parse parse3 = parse2.getCommonParent(parse = parseArray[span.getEnd() - 1]);
        if (parse3 != null) {
            if (entitySet.contains(parse3.getType())) {
                parse3.getParent().setType("NP#" + n);
            } else if (parse3.getType().equals("NML")) {
                parse3.setType("NML#" + n);
            } else if (parse3.getType().equals("NP")) {
                parse3.setType("NP#" + n);
            } else {
                System.out.println("Inserting mention failed: " + parse3.getType() + " Failed id: " + n);
                bl = true;
            }
        } else {
            throw new IllegalArgumentException("Tokens must always have a common parent!");
        }
        return !bl;
    }

    @Override
    public CorefSample read() throws IOException {
        RawCorefSample rawCorefSample = (RawCorefSample)this.samples.read();
        if (rawCorefSample != null) {
            ArrayList<Parse> arrayList = new ArrayList<Parse>();
            List<MucCorefContentHandler.CorefMention[]> list = rawCorefSample.getMentions();
            List<Parse> list2 = rawCorefSample.getParses();
            for (int i = 0; i < list.size(); ++i) {
                MucCorefContentHandler.CorefMention[] corefMentionArray = list.get(i);
                Parse parse = list2.get(i);
                for (Mention mention : this.mentionFinder.getMentions(new DefaultParse(parse, i))) {
                    if (mention.getParse() != null) continue;
                    Parse parse2 = new Parse(parse.getText(), mention.getSpan(), "NML", 1.0, 0);
                    parse.insert(parse2);
                }
                Comparable<Mention>[] comparableArray = parse.getTagNodes();
                for (MucCorefContentHandler.CorefMention corefMention : corefMentionArray) {
                    Span span = MucMentionInserterStream.getMinSpan(parse, corefMention);
                    if (span == null) {
                        span = corefMention.span;
                    }
                    MucMentionInserterStream.addMention(corefMention.id, span, comparableArray);
                }
                parse.show();
                arrayList.add(parse);
            }
            return new CorefSample(arrayList);
        }
        return null;
    }
}

