/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.muc;

import chalk.tools.formats.muc.MucElementNames;
import chalk.tools.formats.muc.SgmlParser;
import chalk.tools.namefind.NameSample;
import chalk.tools.tokenize.Tokenizer;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class MucNameContentHandler
extends SgmlParser.ContentHandler {
    private static final String ENTITY_ELEMENT_NAME = "ENAMEX";
    private static final String TIME_ELEMENT_NAME = "TIMEX";
    private static final String NUM_ELEMENT_NAME = "NUMEX";
    private static final Set<String> NAME_ELEMENT_NAMES;
    private static final Set<String> EXPECTED_TYPES;
    private final Tokenizer tokenizer;
    private final List<NameSample> storedSamples;
    boolean isInsideContentElement = false;
    private final List<String> text = new ArrayList<String>();
    private boolean isClearAdaptiveData = false;
    private final Stack<Span> incompleteNames = new Stack();
    private List<Span> names = new ArrayList<Span>();

    public MucNameContentHandler(Tokenizer tokenizer, List<NameSample> list) {
        this.tokenizer = tokenizer;
        this.storedSamples = list;
    }

    @Override
    public void startElement(String string, Map<String, String> map) throws InvalidFormatException {
        if ("DOC".equals(string)) {
            this.isClearAdaptiveData = true;
        }
        if (MucElementNames.CONTENT_ELEMENTS.contains(string)) {
            this.isInsideContentElement = true;
        }
        if (NAME_ELEMENT_NAMES.contains(string)) {
            String string2 = map.get("TYPE");
            if (!EXPECTED_TYPES.contains(string2)) {
                throw new InvalidFormatException("Unknown timex, numex or namex type: " + string2 + ", expected one of " + EXPECTED_TYPES);
            }
            this.incompleteNames.add(new Span(this.text.size(), this.text.size(), string2.toLowerCase(Locale.ENGLISH)));
        }
    }

    @Override
    public void characters(CharSequence charSequence) {
        if (this.isInsideContentElement) {
            String[] stringArray = this.tokenizer.tokenize(((Object)charSequence).toString());
            this.text.addAll(Arrays.asList(stringArray));
        }
    }

    @Override
    public void endElement(String string) {
        if (NAME_ELEMENT_NAMES.contains(string)) {
            Span span = this.incompleteNames.pop();
            span = new Span(span.getStart(), this.text.size(), span.getType());
            this.names.add(span);
        }
        if (MucElementNames.CONTENT_ELEMENTS.contains(string)) {
            this.storedSamples.add(new NameSample(this.text.toArray(new String[this.text.size()]), this.names.toArray(new Span[this.names.size()]), this.isClearAdaptiveData));
            if (this.isClearAdaptiveData) {
                this.isClearAdaptiveData = false;
            }
            this.text.clear();
            this.names.clear();
            this.isInsideContentElement = false;
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("PERSON");
        hashSet.add("ORGANIZATION");
        hashSet.add("LOCATION");
        hashSet.add("DATE");
        hashSet.add("TIME");
        hashSet.add("MONEY");
        hashSet.add("PERCENT");
        EXPECTED_TYPES = Collections.unmodifiableSet(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add(ENTITY_ELEMENT_NAME);
        hashSet2.add(TIME_ELEMENT_NAME);
        hashSet2.add(NUM_ELEMENT_NAME);
        NAME_ELEMENT_NAMES = Collections.unmodifiableSet(hashSet2);
    }
}

