/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.formats.muc;

import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class SgmlParser {
    private static String extractTagName(CharSequence charSequence) throws InvalidFormatException {
        int n = 1;
        if (charSequence.length() > 1 && charSequence.charAt(1) == '/') {
            n = 2;
        }
        for (int i = 1; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != '>' && !StringUtil.isWhitespace(charSequence.charAt(i))) continue;
            return ((Object)charSequence.subSequence(n, i)).toString();
        }
        throw new InvalidFormatException("Failed to extract tag name!");
    }

    private static Map<String, String> getAttributes(CharSequence charSequence) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < charSequence.length(); ++i) {
            if (StringUtil.isWhitespace(charSequence.charAt(i)) && !bl2) {
                bl = true;
                continue;
            }
            if (bl && ('=' == charSequence.charAt(i) || StringUtil.isWhitespace(charSequence.charAt(i)))) {
                bl = false;
                continue;
            }
            if (bl) {
                stringBuilder.append(charSequence.charAt(i));
                continue;
            }
            if ('\"' == charSequence.charAt(i)) {
                if (bl2) {
                    hashMap.put(stringBuilder.toString(), stringBuilder2.toString());
                    stringBuilder.setLength(0);
                    stringBuilder2.setLength(0);
                }
                bl2 = !bl2;
                continue;
            }
            if (!bl2) continue;
            stringBuilder2.append(charSequence.charAt(i));
        }
        return hashMap;
    }

    public void parse(Reader reader, ContentHandler contentHandler) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = true;
        int n2 = -1;
        while ((n = reader.read()) != -1) {
            if (60 == n) {
                if (bl) {
                    throw new InvalidFormatException("Did not expect < char!");
                }
                if (stringBuilder.toString().trim().length() > 0) {
                    contentHandler.characters(stringBuilder.toString().trim());
                }
                stringBuilder.setLength(0);
                bl = true;
                bl2 = true;
            }
            stringBuilder.appendCodePoint(n);
            if (47 == n && n2 == 60) {
                bl2 = false;
            }
            if (62 == n) {
                if (!bl) {
                    throw new InvalidFormatException("Did not expect > char!");
                }
                if (bl2) {
                    contentHandler.startElement(SgmlParser.extractTagName(stringBuilder), SgmlParser.getAttributes(stringBuilder));
                } else {
                    contentHandler.endElement(SgmlParser.extractTagName(stringBuilder));
                }
                stringBuilder.setLength(0);
                bl = false;
            }
            n2 = n;
        }
        if (bl) {
            throw new InvalidFormatException("Did not find matching > char!");
        }
    }

    public static abstract class ContentHandler {
        public void startElement(String string, Map<String, String> map) throws InvalidFormatException {
        }

        public void characters(CharSequence charSequence) throws InvalidFormatException {
        }

        public void endElement(String string) throws InvalidFormatException {
        }
    }
}

