/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.lang.english;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.mention.DefaultParse;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.parser.Parse;
import chalk.tools.util.Span;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class CorefParse {
    private Map<Parse, Integer> parseMap;
    private List<Parse> parses;

    public CorefParse(List<Parse> list, DiscourseEntity[] discourseEntityArray) {
        this.parses = list;
        this.parseMap = new HashMap<Parse, Integer>();
        int n = discourseEntityArray.length;
        for (int i = 0; i < n; ++i) {
            if (discourseEntityArray[i].getNumMentions() <= 1) continue;
            Iterator<MentionContext> iterator = discourseEntityArray[i].getMentions();
            while (iterator.hasNext()) {
                MentionContext mentionContext = iterator.next();
                Parse parse = ((DefaultParse)mentionContext.getParse()).getParse();
                this.parseMap.put(parse, i + 1);
            }
        }
    }

    public void show() {
        int n = this.parses.size();
        for (int i = 0; i < n; ++i) {
            Parse parse = this.parses.get(i);
            this.show(parse);
            System.out.println();
        }
    }

    private void show(Parse parse) {
        int n = parse.getSpan().getStart();
        if (!parse.getType().equals("TK")) {
            System.out.print("(");
            System.out.print(parse.getType());
            if (this.parseMap.containsKey(parse)) {
                System.out.print("#" + this.parseMap.get(parse));
            }
            System.out.print(" ");
        }
        for (Parse parse2 : parse.getChildren()) {
            Span span = parse2.getSpan();
            if (n < span.getStart()) {
                System.out.print(parse.getText().substring(n, span.getStart()));
            }
            this.show(parse2);
            n = span.getEnd();
        }
        System.out.print(parse.getText().substring(n, parse.getSpan().getEnd()));
        if (!parse.getType().equals("TK")) {
            System.out.print(")");
        }
    }
}

