/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.lang.spanish;

import chalk.tools.namefind.NameFinderEventStream;
import chalk.tools.namefind.NameFinderME;
import chalk.tools.util.Span;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import nak.io.SuffixSensitiveGISModelReader;
import nak.model.MaxentModel;

public class TokenChunker {
    private NameFinderME nameFinder;

    public TokenChunker(String string) throws IOException {
        this.nameFinder = new NameFinderME((MaxentModel)new SuffixSensitiveGISModelReader(new File(string)).getModel());
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: java opennlp.tools.spanish.TokenChunker model < tokenized_sentences");
            System.exit(1);
        }
        TokenChunker tokenChunker = new TokenChunker(stringArray[0]);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, "ISO-8859-1"));
        PrintStream printStream = new PrintStream((OutputStream)System.out, true, "ISO-8859-1");
        String string = bufferedReader.readLine();
        while (string != null) {
            if (string.equals("")) {
                printStream.println();
            } else {
                String[] stringArray2 = string.split(" ");
                Span[] spanArray = tokenChunker.nameFinder.find(stringArray2);
                String[] stringArray3 = NameFinderEventStream.generateOutcomes(spanArray, null, stringArray2.length);
                int n = stringArray3.length;
                for (int i = 0; i < n; ++i) {
                    if (i == 0) {
                        printStream.print(stringArray2[i]);
                        continue;
                    }
                    if (stringArray3[i].equals("cont")) {
                        printStream.print("_" + stringArray2[i]);
                        continue;
                    }
                    printStream.print(" " + stringArray2[i]);
                }
                printStream.println();
            }
            string = bufferedReader.readLine();
        }
    }
}

