/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.namefind;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.namefind.TokenNameFinder;
import chalk.tools.util.Span;
import chalk.tools.util.StringList;
import java.util.LinkedList;

public class DictionaryNameFinder
implements TokenNameFinder {
    private static final String DEFAULT_TYPE = "default";
    private Dictionary mDictionary;
    private final String type;

    public DictionaryNameFinder(Dictionary dictionary, String string) {
        this.mDictionary = dictionary;
        if (string == null) {
            throw new IllegalArgumentException("type cannot be null!");
        }
        this.type = string;
    }

    public DictionaryNameFinder(Dictionary dictionary) {
        this(dictionary, DEFAULT_TYPE);
    }

    @Override
    public Span[] find(String[] stringArray) {
        LinkedList<Span> linkedList = new LinkedList<Span>();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            Span span = null;
            String[] stringArray2 = new String[]{};
            for (int j = i; j < stringArray.length && (n = j - i + 1) <= this.mDictionary.getMaxTokenCount(); ++j) {
                stringArray2 = new String[n];
                System.arraycopy(stringArray, i, stringArray2, 0, n);
                StringList stringList = new StringList(stringArray2);
                if (!this.mDictionary.contains(stringList)) continue;
                span = new Span(i, j + 1, this.type);
            }
            if (span == null) continue;
            linkedList.add(span);
            i += span.length() - 1;
        }
        return linkedList.toArray(new Span[linkedList.size()]);
    }

    @Override
    public void clearAdaptiveData() {
    }
}

