/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.namefind;

import chalk.tools.namefind.DefaultNameContextGenerator;
import chalk.tools.namefind.NameContextGenerator;
import chalk.tools.namefind.NameSample;
import chalk.tools.namefind.NameSampleDataStream;
import chalk.tools.util.AbstractEventStream;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import chalk.tools.util.Span;
import chalk.tools.util.featuregen.AdaptiveFeatureGenerator;
import chalk.tools.util.featuregen.AdditionalContextFeatureGenerator;
import chalk.tools.util.featuregen.WindowFeatureGenerator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nak.model.Event;

public class NameFinderEventStream
extends AbstractEventStream<NameSample> {
    private NameContextGenerator contextGenerator;
    private AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();
    private String type;

    public NameFinderEventStream(ObjectStream<NameSample> objectStream, String string, NameContextGenerator nameContextGenerator) {
        super(objectStream);
        this.contextGenerator = nameContextGenerator;
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
        this.type = string != null ? string : "default";
    }

    public NameFinderEventStream(ObjectStream<NameSample> objectStream) {
        this(objectStream, null, new DefaultNameContextGenerator());
    }

    public static String[] generateOutcomes(Span[] spanArray, String string, int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "other";
        }
        for (Span span : spanArray) {
            stringArray[span.getStart()] = span.getType() == null ? string + "-" + "start" : span.getType() + "-" + "start";
            for (int i = span.getStart() + 1; i < span.getEnd(); ++i) {
                stringArray[i] = span.getType() == null ? string + "-" + "cont" : span.getType() + "-" + "cont";
            }
        }
        return stringArray;
    }

    public static List<Event> generateEvents(String[] stringArray, String[] stringArray2, NameContextGenerator nameContextGenerator) {
        ArrayList<Event> arrayList = new ArrayList<Event>(stringArray2.length);
        for (int i = 0; i < stringArray2.length; ++i) {
            arrayList.add(new Event(stringArray2[i], nameContextGenerator.getContext(i, stringArray, stringArray2, null)));
        }
        nameContextGenerator.updateAdaptiveData(stringArray, stringArray2);
        return arrayList;
    }

    @Override
    protected Iterator<Event> createEvents(NameSample nameSample) {
        if (nameSample.isClearAdaptiveDataSet()) {
            this.contextGenerator.clearAdaptiveData();
        }
        String[] stringArray = NameFinderEventStream.generateOutcomes(nameSample.getNames(), this.type, nameSample.getSentence().length);
        this.additionalContextFeatureGenerator.setCurrentContext(nameSample.getAdditionalContext());
        String[] stringArray2 = new String[nameSample.getSentence().length];
        for (int i = 0; i < nameSample.getSentence().length; ++i) {
            stringArray2[i] = nameSample.getSentence()[i];
        }
        return NameFinderEventStream.generateEvents(stringArray2, stringArray, this.contextGenerator).iterator();
    }

    public static String[][] additionalContext(String[] stringArray, Map<String, String> map) {
        String[][] stringArray2 = new String[stringArray.length][1];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = map.get(stringArray[i]);
            stringArray2[i][0] = "pd=" + string;
        }
        return stringArray2;
    }

    @Deprecated
    public static final void main(String[] stringArray) throws IOException {
        if (stringArray.length != 0) {
            System.err.println("Usage: NameFinderEventStream < training files");
            System.exit(1);
        }
        NameFinderEventStream nameFinderEventStream = new NameFinderEventStream(new NameSampleDataStream(new PlainTextByLineStream(new InputStreamReader(System.in))));
        while (nameFinderEventStream.hasNext()) {
            System.out.println(nameFinderEventStream.next());
        }
    }
}

