/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.namefind;

import chalk.tools.namefind.DefaultNameContextGenerator;
import chalk.tools.namefind.NameContextGenerator;
import chalk.tools.namefind.NameFinderEventStream;
import chalk.tools.namefind.NameFinderSequenceValidator;
import chalk.tools.namefind.NameSample;
import chalk.tools.namefind.NameSampleSequenceStream;
import chalk.tools.namefind.TokenNameFinder;
import chalk.tools.namefind.TokenNameFinderModel;
import chalk.tools.util.BeamSearch;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.Sequence;
import chalk.tools.util.SequenceValidator;
import chalk.tools.util.Span;
import chalk.tools.util.TrainingParameters;
import chalk.tools.util.featuregen.AdaptiveFeatureGenerator;
import chalk.tools.util.featuregen.AdditionalContextFeatureGenerator;
import chalk.tools.util.featuregen.BigramNameFeatureGenerator;
import chalk.tools.util.featuregen.CachedFeatureGenerator;
import chalk.tools.util.featuregen.FeatureGeneratorResourceProvider;
import chalk.tools.util.featuregen.GeneratorFactory;
import chalk.tools.util.featuregen.OutcomePriorFeatureGenerator;
import chalk.tools.util.featuregen.PreviousMapFeatureGenerator;
import chalk.tools.util.featuregen.SentenceFeatureGenerator;
import chalk.tools.util.featuregen.TokenClassFeatureGenerator;
import chalk.tools.util.featuregen.TokenFeatureGenerator;
import chalk.tools.util.featuregen.WindowFeatureGenerator;
import chalk.tools.util.model.ModelUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nak.maxent.GIS;
import nak.maxent.GISModel;
import nak.model.AbstractModel;
import nak.model.DataIndexer;
import nak.model.EventStream;
import nak.model.MaxentModel;
import nak.model.SequenceStream;
import nak.model.TrainUtil;
import nak.model.TwoPassDataIndexer;

public class NameFinderME
implements TokenNameFinder {
    private static String[][] EMPTY = new String[0][0];
    public static final int DEFAULT_BEAM_SIZE = 3;
    private static final Pattern typedOutcomePattern = Pattern.compile("(.+)-\\w+");
    public static final String START = "start";
    public static final String CONTINUE = "cont";
    public static final String OTHER = "other";
    protected MaxentModel model;
    protected NameContextGenerator contextGenerator;
    private Sequence bestSequence;
    private BeamSearch<String> beam;
    private AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();

    public NameFinderME(TokenNameFinderModel tokenNameFinderModel) {
        this(tokenNameFinderModel, 3);
    }

    public NameFinderME(TokenNameFinderModel tokenNameFinderModel, AdaptiveFeatureGenerator adaptiveFeatureGenerator, int n, SequenceValidator<String> nameFinderSequenceValidator) {
        this.model = tokenNameFinderModel.getNameFinderModel();
        if (adaptiveFeatureGenerator != null) {
            this.contextGenerator = new DefaultNameContextGenerator(adaptiveFeatureGenerator);
        } else {
            AdaptiveFeatureGenerator adaptiveFeatureGenerator2 = tokenNameFinderModel.createFeatureGenerators();
            if (adaptiveFeatureGenerator2 == null) {
                adaptiveFeatureGenerator2 = NameFinderME.createFeatureGenerator();
            }
            this.contextGenerator = new DefaultNameContextGenerator(adaptiveFeatureGenerator2);
        }
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
        if (nameFinderSequenceValidator == null) {
            nameFinderSequenceValidator = new NameFinderSequenceValidator();
        }
        this.beam = new BeamSearch<String>(n, this.contextGenerator, this.model, nameFinderSequenceValidator, n);
    }

    public NameFinderME(TokenNameFinderModel tokenNameFinderModel, AdaptiveFeatureGenerator adaptiveFeatureGenerator, int n) {
        this(tokenNameFinderModel, adaptiveFeatureGenerator, n, null);
    }

    public NameFinderME(TokenNameFinderModel tokenNameFinderModel, int n) {
        this(tokenNameFinderModel, null, n);
    }

    @Deprecated
    public NameFinderME(MaxentModel maxentModel) {
        this(maxentModel, new DefaultNameContextGenerator(), 3);
    }

    @Deprecated
    public NameFinderME(MaxentModel maxentModel, NameContextGenerator nameContextGenerator) {
        this(maxentModel, nameContextGenerator, 3);
    }

    @Deprecated
    public NameFinderME(MaxentModel maxentModel, NameContextGenerator nameContextGenerator, int n) {
        this.model = maxentModel;
        this.contextGenerator = nameContextGenerator;
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
        this.beam = new BeamSearch<String>(n, nameContextGenerator, maxentModel, new NameFinderSequenceValidator(), n);
    }

    private static AdaptiveFeatureGenerator createFeatureGenerator() {
        return new CachedFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)new TokenFeatureGenerator(), 2, 2), new WindowFeatureGenerator((AdaptiveFeatureGenerator)new TokenClassFeatureGenerator(true), 2, 2), new OutcomePriorFeatureGenerator(), new PreviousMapFeatureGenerator(), new BigramNameFeatureGenerator(), new SentenceFeatureGenerator(true, false));
    }

    private static AdaptiveFeatureGenerator createFeatureGenerator(byte[] byArray, final Map<String, Object> map) throws IOException {
        AdaptiveFeatureGenerator adaptiveFeatureGenerator = byArray != null ? GeneratorFactory.create(new ByteArrayInputStream(byArray), new FeatureGeneratorResourceProvider(){

            @Override
            public Object getResource(String string) {
                if (map != null) {
                    return map.get(string);
                }
                return null;
            }
        }) : null;
        return adaptiveFeatureGenerator;
    }

    @Override
    public Span[] find(String[] stringArray) {
        return this.find(stringArray, EMPTY);
    }

    public Span[] find(String[] stringArray, String[][] stringArray2) {
        this.additionalContextFeatureGenerator.setCurrentContext(stringArray2);
        this.bestSequence = this.beam.bestSequence((String[])stringArray, (Object[])stringArray2);
        List<String> list = this.bestSequence.getOutcomes();
        this.contextGenerator.updateAdaptiveData(stringArray, list.toArray(new String[list.size()]));
        int n = -1;
        int n2 = -1;
        ArrayList<Span> arrayList = new ArrayList<Span>(stringArray.length);
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string.endsWith(START)) {
                if (n != -1) {
                    arrayList.add(new Span(n, n2, NameFinderME.extractNameType(list.get(i - 1))));
                }
                n = i;
                n2 = i + 1;
                continue;
            }
            if (string.endsWith(CONTINUE)) {
                n2 = i + 1;
                continue;
            }
            if (!string.endsWith(OTHER) || n == -1) continue;
            arrayList.add(new Span(n, n2, NameFinderME.extractNameType(list.get(i - 1))));
            n = -1;
            n2 = -1;
        }
        if (n != -1) {
            arrayList.add(new Span(n, n2, NameFinderME.extractNameType(list.get(list.size() - 1))));
        }
        return arrayList.toArray(new Span[arrayList.size()]);
    }

    @Override
    public void clearAdaptiveData() {
        this.contextGenerator.clearAdaptiveData();
    }

    public void probs(double[] dArray) {
        this.bestSequence.getProbs(dArray);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public double[] probs(Span[] spanArray) {
        double[] dArray = new double[spanArray.length];
        double[] dArray2 = this.bestSequence.getProbs();
        for (int i = 0; i < spanArray.length; ++i) {
            double d = 0.0;
            for (int j = spanArray[i].getStart(); j < spanArray[i].getEnd(); ++j) {
                d += dArray2[j];
            }
            dArray[i] = d /= (double)spanArray[i].length();
        }
        return dArray;
    }

    public static TokenNameFinderModel train(String string, String string2, ObjectStream<NameSample> objectStream, TrainingParameters trainingParameters, AdaptiveFeatureGenerator adaptiveFeatureGenerator, Map<String, Object> map) throws IOException {
        AbstractModel abstractModel;
        if (string == null) {
            throw new IllegalArgumentException("languageCode must not be null!");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AdaptiveFeatureGenerator adaptiveFeatureGenerator2 = adaptiveFeatureGenerator != null ? adaptiveFeatureGenerator : NameFinderME.createFeatureGenerator();
        if (!TrainUtil.isSequenceTraining(trainingParameters.getSettings())) {
            NameFinderEventStream nameFinderEventStream = new NameFinderEventStream(objectStream, string2, new DefaultNameContextGenerator(adaptiveFeatureGenerator2));
            abstractModel = TrainUtil.train((EventStream)nameFinderEventStream, trainingParameters.getSettings(), hashMap);
        } else {
            NameSampleSequenceStream nameSampleSequenceStream = new NameSampleSequenceStream(objectStream, adaptiveFeatureGenerator2);
            abstractModel = TrainUtil.train((SequenceStream)nameSampleSequenceStream, trainingParameters.getSettings(), hashMap);
        }
        return new TokenNameFinderModel(string, abstractModel, map, hashMap);
    }

    public static TokenNameFinderModel train(String string, String string2, ObjectStream<NameSample> objectStream, TrainingParameters trainingParameters, byte[] byArray, Map<String, Object> map) throws IOException {
        TokenNameFinderModel tokenNameFinderModel = NameFinderME.train(string, string2, objectStream, trainingParameters, NameFinderME.createFeatureGenerator(byArray, map), map);
        if (byArray != null) {
            tokenNameFinderModel = tokenNameFinderModel.updateFeatureGenerator(byArray);
        }
        return tokenNameFinderModel;
    }

    public static TokenNameFinderModel train(String string, String string2, ObjectStream<NameSample> objectStream, AdaptiveFeatureGenerator adaptiveFeatureGenerator, Map<String, Object> map, int n, int n2) throws IOException {
        return NameFinderME.train(string, string2, objectStream, ModelUtil.createTrainingParameters(n, n2), adaptiveFeatureGenerator, map);
    }

    @Deprecated
    public static TokenNameFinderModel train(String string, String string2, ObjectStream<NameSample> objectStream, Map<String, Object> map, int n, int n2) throws IOException {
        return NameFinderME.train(string, string2, objectStream, (AdaptiveFeatureGenerator)null, map, n, n2);
    }

    public static TokenNameFinderModel train(String string, String string2, ObjectStream<NameSample> objectStream, Map<String, Object> map) throws IOException {
        return NameFinderME.train(string, string2, objectStream, map, 100, 5);
    }

    @Deprecated
    public static TokenNameFinderModel train(String string, String string2, ObjectStream<NameSample> objectStream, byte[] byArray, Map<String, Object> map, int n, int n2) throws IOException {
        AdaptiveFeatureGenerator adaptiveFeatureGenerator = NameFinderME.createFeatureGenerator(byArray, map);
        TokenNameFinderModel tokenNameFinderModel = NameFinderME.train(string, string2, objectStream, adaptiveFeatureGenerator, map, n, n2);
        if (byArray != null) {
            tokenNameFinderModel = tokenNameFinderModel.updateFeatureGenerator(byArray);
        }
        return tokenNameFinderModel;
    }

    @Deprecated
    public static GISModel train(EventStream eventStream, int n, int n2) throws IOException {
        return GIS.trainModel((int)n, (DataIndexer)new TwoPassDataIndexer(eventStream, n2));
    }

    static final String extractNameType(String string) {
        Matcher matcher = typedOutcomePattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            return string2;
        }
        return null;
    }

    public static Span[] dropOverlappingSpans(Span[] spanArray) {
        ArrayList arrayList = new ArrayList(spanArray.length);
        Collections.addAll(arrayList, spanArray);
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        Span span = null;
        while (iterator.hasNext()) {
            Span span2 = (Span)iterator.next();
            if (span != null && span.intersects(span2)) {
                iterator.remove();
                span2 = span;
            }
            span = span2;
        }
        return arrayList.toArray(new Span[arrayList.size()]);
    }
}

