/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.namefind;

import chalk.tools.tokenize.WhitespaceTokenizer;
import chalk.tools.util.Span;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class NameSample {
    private final List<String> sentence;
    private final List<Span> names;
    private final String[][] additionalContext;
    private final boolean isClearAdaptiveData;
    public static final String DEFAULT_TYPE = "default";
    private static final Pattern START_TAG_PATTERN = Pattern.compile("<START(:([^:>\\s]*))?>");

    public NameSample(String[] stringArray, Span[] spanArray, String[][] stringArray2, boolean bl) {
        if (stringArray == null) {
            throw new IllegalArgumentException("sentence must not be null!");
        }
        if (spanArray == null) {
            spanArray = new Span[]{};
        }
        this.sentence = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(stringArray)));
        this.names = Collections.unmodifiableList(new ArrayList<Span>(Arrays.asList(spanArray)));
        if (stringArray2 != null) {
            this.additionalContext = new String[stringArray2.length][];
            for (int i = 0; i < stringArray2.length; ++i) {
                this.additionalContext[i] = new String[stringArray2[i].length];
                System.arraycopy(stringArray2[i], 0, this.additionalContext[i], 0, stringArray2[i].length);
            }
        } else {
            this.additionalContext = null;
        }
        this.isClearAdaptiveData = bl;
    }

    public NameSample(String[] stringArray, Span[] spanArray, boolean bl) {
        this(stringArray, spanArray, null, bl);
    }

    public String[] getSentence() {
        return this.sentence.toArray(new String[this.sentence.size()]);
    }

    public Span[] getNames() {
        return this.names.toArray(new Span[this.names.size()]);
    }

    public String[][] getAdditionalContext() {
        return this.additionalContext;
    }

    public boolean isClearAdaptiveDataSet() {
        return this.isClearAdaptiveData;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NameSample) {
            NameSample nameSample = (NameSample)object;
            return Arrays.equals(this.getSentence(), nameSample.getSentence()) && Arrays.equals(this.getNames(), nameSample.getNames()) && Arrays.equals((Object[])this.getAdditionalContext(), (Object[])nameSample.getAdditionalContext()) && this.isClearAdaptiveDataSet() == nameSample.isClearAdaptiveDataSet();
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isClearAdaptiveDataSet()) {
            stringBuilder.append("\n");
        }
        for (int i = 0; i < this.sentence.size(); ++i) {
            for (Span span : this.names) {
                if (span.getStart() == i) {
                    if (span.getType() == null) {
                        stringBuilder.append("<START>").append(' ');
                    } else {
                        stringBuilder.append("<START:").append(span.getType()).append("> ");
                    }
                }
                if (span.getEnd() != i) continue;
                stringBuilder.append("<END>").append(' ');
            }
            stringBuilder.append(this.sentence.get(i)).append(' ');
        }
        if (this.sentence.size() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        for (Span span : this.names) {
            if (span.getEnd() != this.sentence.size()) continue;
            stringBuilder.append(' ').append("<END>");
        }
        return stringBuilder.toString();
    }

    private static String errorTokenWithContext(String[] stringArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 1) {
            stringBuilder.append(stringArray[n - 2]).append(" ");
        }
        if (n > 0) {
            stringBuilder.append(stringArray[n - 1]).append(" ");
        }
        stringBuilder.append("###");
        stringBuilder.append(stringArray[n]);
        stringBuilder.append("###").append(" ");
        if (n + 1 < stringArray.length) {
            stringBuilder.append(stringArray[n + 1]).append(" ");
        }
        if (n + 2 < stringArray.length) {
            stringBuilder.append(stringArray[n + 2]);
        }
        return stringBuilder.toString();
    }

    public static NameSample parse(String string, boolean bl) throws IOException {
        return NameSample.parse(string, DEFAULT_TYPE, bl);
    }

    public static NameSample parse(String string, String string2, boolean bl) throws IOException {
        Span[] spanArray;
        String[] stringArray = WhitespaceTokenizer.INSTANCE.tokenize(string);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        ArrayList<Span> arrayList2 = new ArrayList<Span>();
        String string3 = string2;
        int n = -1;
        int n2 = 0;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            spanArray = START_TAG_PATTERN.matcher(stringArray[i]);
            if (spanArray.matches()) {
                if (bl2) {
                    throw new IOException("Found unexpected annotation while handling a name sequence: " + NameSample.errorTokenWithContext(stringArray, i));
                }
                bl2 = true;
                n = n2;
                String string4 = spanArray.group(2);
                if (string4 == null) continue;
                if (string4.length() == 0) {
                    throw new IOException("Missing a name type: " + NameSample.errorTokenWithContext(stringArray, i));
                }
                string3 = string4;
                continue;
            }
            if (stringArray[i].equals("<END>")) {
                if (!bl2) {
                    throw new IOException("Found unexpected annotation: " + NameSample.errorTokenWithContext(stringArray, i));
                }
                bl2 = false;
                arrayList2.add(new Span(n, n2, string3));
                continue;
            }
            arrayList.add(stringArray[i]);
            ++n2;
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        spanArray = arrayList2.toArray(new Span[arrayList2.size()]);
        return new NameSample(stringArray2, spanArray, bl);
    }
}

