/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.namefind;

import chalk.tools.namefind.TokenNameFinder;
import chalk.tools.util.Span;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexNameFinder
implements TokenNameFinder {
    private final Pattern[] mPatterns;

    public RegexNameFinder(Pattern[] patternArray) {
        if (patternArray == null || patternArray.length == 0) {
            throw new IllegalArgumentException("patterns must not be null or empty!");
        }
        this.mPatterns = patternArray;
    }

    @Override
    public Span[] find(String[] stringArray) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        StringBuffer stringBuffer = new StringBuffer(stringArray.length * 10);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringBuffer.length();
            hashMap.put(n, i);
            stringBuffer.append(stringArray[i]);
            int n2 = stringBuffer.length();
            hashMap.put(n2, i);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(' ');
        }
        LinkedList<Span> linkedList = new LinkedList<Span>();
        for (Pattern pattern : this.mPatterns) {
            Matcher matcher = pattern.matcher(stringBuffer);
            while (matcher.find()) {
                Integer n = (Integer)hashMap.get(matcher.start());
                Integer n3 = (Integer)hashMap.get(matcher.end());
                if (n == null || n3 == null) continue;
                Span span = new Span(n, (int)n3);
                linkedList.add(span);
            }
        }
        return linkedList.toArray(new Span[linkedList.size()]);
    }

    @Override
    public void clearAdaptiveData() {
    }
}

