/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.namefind;

import chalk.tools.namefind.NameFinderME;
import chalk.tools.namefind.NameSample;
import chalk.tools.namefind.TokenNameFinderEvaluationMonitor;
import chalk.tools.namefind.TokenNameFinderEvaluator;
import chalk.tools.namefind.TokenNameFinderModel;
import chalk.tools.util.FilterObjectStream;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.TrainingParameters;
import chalk.tools.util.eval.CrossValidationPartitioner;
import chalk.tools.util.eval.FMeasure;
import chalk.tools.util.model.ModelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class TokenNameFinderCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private final String type;
    private final byte[] featureGeneratorBytes;
    private final Map<String, Object> resources;
    private TokenNameFinderEvaluationMonitor[] listeners;
    private FMeasure fmeasure = new FMeasure();

    @Deprecated
    public TokenNameFinderCrossValidator(String string, int n, int n2) {
        this(string, null, n, n2);
    }

    @Deprecated
    public TokenNameFinderCrossValidator(String string, String string2, int n, int n2) {
        this.languageCode = string;
        this.type = string2;
        this.params = ModelUtil.createTrainingParameters(n2, n);
        this.featureGeneratorBytes = null;
        this.resources = Collections.emptyMap();
    }

    @Deprecated
    public TokenNameFinderCrossValidator(String string, String string2, byte[] byArray, Map<String, Object> map, int n, int n2) {
        this.languageCode = string;
        this.type = string2;
        this.featureGeneratorBytes = byArray;
        this.resources = map;
        this.params = ModelUtil.createTrainingParameters(n, n2);
    }

    public TokenNameFinderCrossValidator(String string, String string2, TrainingParameters trainingParameters, byte[] byArray, Map<String, Object> map, TokenNameFinderEvaluationMonitor ... tokenNameFinderEvaluationMonitorArray) {
        this.languageCode = string;
        this.type = string2;
        this.featureGeneratorBytes = byArray;
        this.resources = map;
        this.params = trainingParameters;
        this.listeners = tokenNameFinderEvaluationMonitorArray;
    }

    public void evaluate(ObjectStream<NameSample> objectStream, int n) throws IOException {
        CrossValidationPartitioner<DocumentSample> crossValidationPartitioner = new CrossValidationPartitioner<DocumentSample>(new NameToDocumentSampleStream(objectStream), n);
        while (crossValidationPartitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<DocumentSample> trainingSampleStream = crossValidationPartitioner.next();
            TokenNameFinderModel tokenNameFinderModel = NameFinderME.train(this.languageCode, this.type, (ObjectStream<NameSample>)new DocumentToNameSampleStream(trainingSampleStream), this.params, this.featureGeneratorBytes, this.resources);
            TokenNameFinderEvaluator tokenNameFinderEvaluator = new TokenNameFinderEvaluator(new NameFinderME(tokenNameFinderModel), this.listeners);
            tokenNameFinderEvaluator.evaluate(new DocumentToNameSampleStream(trainingSampleStream.getTestSampleStream()));
            this.fmeasure.mergeInto(tokenNameFinderEvaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }

    private class DocumentToNameSampleStream
    extends FilterObjectStream<DocumentSample, NameSample> {
        private Iterator<NameSample> documentSamples;

        protected DocumentToNameSampleStream(ObjectStream<DocumentSample> objectStream) {
            super(objectStream);
            this.documentSamples = Collections.emptyList().iterator();
        }

        @Override
        public NameSample read() throws IOException {
            if (this.documentSamples.hasNext()) {
                return this.documentSamples.next();
            }
            DocumentSample documentSample = (DocumentSample)this.samples.read();
            if (documentSample != null) {
                this.documentSamples = Arrays.asList(documentSample.getSamples()).iterator();
                return this.read();
            }
            return null;
        }
    }

    private class NameToDocumentSampleStream
    extends FilterObjectStream<NameSample, DocumentSample> {
        private NameSample beginSample;

        protected NameToDocumentSampleStream(ObjectStream<NameSample> objectStream) {
            super(objectStream);
        }

        @Override
        public DocumentSample read() throws IOException {
            NameSample nameSample;
            ArrayList<NameSample> arrayList = new ArrayList<NameSample>();
            if (this.beginSample == null) {
                this.beginSample = (NameSample)this.samples.read();
            }
            if (this.beginSample == null) {
                return null;
            }
            arrayList.add(this.beginSample);
            while ((nameSample = (NameSample)this.samples.read()) != null) {
                if (nameSample.isClearAdaptiveDataSet()) {
                    this.beginSample = nameSample;
                    break;
                }
                arrayList.add(nameSample);
            }
            if (nameSample == null) {
                this.beginSample = null;
            }
            return new DocumentSample(arrayList.toArray(new NameSample[arrayList.size()]));
        }

        @Override
        public void reset() throws IOException, UnsupportedOperationException {
            super.reset();
            this.beginSample = null;
        }
    }

    private class DocumentSample {
        private NameSample[] samples;

        DocumentSample(NameSample[] nameSampleArray) {
            this.samples = nameSampleArray;
        }

        private NameSample[] getSamples() {
            return this.samples;
        }
    }
}

