/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.namefind;

import chalk.tools.cmdline.PerformanceMonitor;
import chalk.tools.namefind.NameFinderME;
import chalk.tools.namefind.NameSample;
import chalk.tools.namefind.NameSampleDataStream;
import chalk.tools.namefind.TokenNameFinder;
import chalk.tools.namefind.TokenNameFinderEvaluationMonitor;
import chalk.tools.namefind.TokenNameFinderModel;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.PlainTextByLineStream;
import chalk.tools.util.Span;
import chalk.tools.util.eval.Evaluator;
import chalk.tools.util.eval.FMeasure;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TokenNameFinderEvaluator
extends Evaluator<NameSample> {
    private FMeasure fmeasure = new FMeasure();
    private TokenNameFinder nameFinder;

    public TokenNameFinderEvaluator(TokenNameFinder tokenNameFinder, TokenNameFinderEvaluationMonitor ... tokenNameFinderEvaluationMonitorArray) {
        super(tokenNameFinderEvaluationMonitorArray);
        this.nameFinder = tokenNameFinder;
    }

    @Override
    protected NameSample processSample(NameSample nameSample) {
        if (nameSample.isClearAdaptiveDataSet()) {
            this.nameFinder.clearAdaptiveData();
        }
        Object[] objectArray = this.nameFinder.find(nameSample.getSentence());
        Object[] objectArray2 = nameSample.getNames();
        for (int i = 0; i < objectArray2.length; ++i) {
            if (objectArray2[i].getType() != null) continue;
            objectArray2[i] = new Span(((Span)objectArray2[i]).getStart(), ((Span)objectArray2[i]).getEnd(), "default");
        }
        this.fmeasure.updateScores(objectArray2, objectArray);
        return new NameSample(nameSample.getSentence(), (Span[])objectArray, nameSample.isClearAdaptiveDataSet());
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }

    @Deprecated
    public static void main(String[] stringArray) throws IOException, InvalidFormatException {
        if (stringArray.length == 4) {
            System.out.println("Loading name finder model ...");
            FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
            TokenNameFinderModel tokenNameFinderModel = new TokenNameFinderModel(fileInputStream);
            NameFinderME nameFinderME = new NameFinderME(tokenNameFinderModel);
            System.out.println("Performing evaluation ...");
            TokenNameFinderEvaluator tokenNameFinderEvaluator = new TokenNameFinderEvaluator(nameFinderME, new TokenNameFinderEvaluationMonitor[0]);
            final NameSampleDataStream nameSampleDataStream = new NameSampleDataStream(new PlainTextByLineStream(new InputStreamReader((InputStream)new FileInputStream(stringArray[2]), stringArray[1])));
            final PerformanceMonitor performanceMonitor = new PerformanceMonitor("sent");
            performanceMonitor.startAndPrintThroughput();
            ObjectStream<NameSample> objectStream = new ObjectStream<NameSample>(){

                @Override
                public NameSample read() throws IOException {
                    performanceMonitor.incrementCounter();
                    return nameSampleDataStream.read();
                }

                @Override
                public void reset() throws IOException {
                    nameSampleDataStream.reset();
                }

                @Override
                public void close() throws IOException {
                    nameSampleDataStream.close();
                }
            };
            tokenNameFinderEvaluator.evaluate(objectStream);
            performanceMonitor.stopAndPrintFinalResult();
            System.out.println();
            System.out.println("F-Measure: " + tokenNameFinderEvaluator.getFMeasure().getFMeasure());
            System.out.println("Recall: " + tokenNameFinderEvaluator.getFMeasure().getRecallScore());
            System.out.println("Precision: " + tokenNameFinderEvaluator.getFMeasure().getPrecisionScore());
        }
    }
}

